/*
 * Decompiled with CFR 0.152.
 */
package org.kie.test.util.logging;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.EnsureExceptionHandling;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.PostCompileProcessor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class FilteredPatternLayout
extends PatternLayout {
    private final Set<String> filteredPackages = new HashSet<String>();

    public void setFilter(String filter) {
        this.filteredPackages.add(filter);
    }

    public void start() {
        this.setPostCompileProcessor((PostCompileProcessor)new FilterExceptionHandling(this.filteredPackages));
        super.start();
    }

    private static class FilteringThrowableProxyConverter
    extends ThrowableProxyConverter {
        private Set<String> filterSet = null;

        public FilteringThrowableProxyConverter(Set<String> filterSet) {
            this.filterSet = filterSet;
        }

        protected String throwableProxyToString(IThrowableProxy tp) {
            StringBuilder buf = new StringBuilder(32);
            for (IThrowableProxy currentThrowable = tp; currentThrowable != null; currentThrowable = currentThrowable.getCause()) {
                this.printThrowableProxy(buf, currentThrowable);
            }
            return buf.toString();
        }

        private void printThrowableProxy(StringBuilder buf, IThrowableProxy tp) {
            ThrowableProxyUtil.subjoinFirstLine((StringBuilder)buf, (IThrowableProxy)tp);
            buf.append(CoreConstants.LINE_SEPARATOR);
            StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
            int commonFrames = tp.getCommonFrames();
            boolean unrestrictedPrinting = true;
            int maxIndex = stepArray.length;
            if (commonFrames > 0 && unrestrictedPrinting) {
                maxIndex -= commonFrames;
            }
            for (int i = 0; i < maxIndex; ++i) {
                if (this.startsWithAFilteredPattern(stepArray[i])) continue;
                String string = stepArray[i].toString();
                buf.append('\t');
                buf.append(string);
                this.extraData(buf, stepArray[i]);
                buf.append(CoreConstants.LINE_SEPARATOR);
            }
            if (commonFrames > 0 && unrestrictedPrinting) {
                buf.append("\t... ").append(tp.getCommonFrames()).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
            }
        }

        private boolean startsWithAFilteredPattern(StackTraceElementProxy step) {
            Iterator<String> iterator = this.filterSet.iterator();
            String className = step.getStackTraceElement().getClassName();
            while (iterator.hasNext()) {
                if (!className.startsWith(iterator.next())) continue;
                return true;
            }
            return false;
        }
    }

    private static class FilterExceptionHandling
    extends EnsureExceptionHandling {
        private Converter<ILoggingEvent> filteringConverter = null;

        public FilterExceptionHandling(Set<String> filterSet) {
            this.filteringConverter = new FilteringThrowableProxyConverter((Set)((HashSet)filterSet).clone());
        }

        public void process(Converter<ILoggingEvent> head) {
            if (head == null) {
                throw new IllegalArgumentException("Cannot process empty chain!");
            }
            if (!this.chainHandlesThrowable(head)) {
                Converter tail = ConverterUtil.findTail(head);
                Converter<ILoggingEvent> exConverter = this.filteringConverter;
                tail.setNext(exConverter);
            }
        }
    }
}

