/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.backend;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefRegistry;
import org.dashbuilder.dataset.impl.SQLDataSetDefBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.Startup;

@Startup
@ApplicationScoped
public class DashbuilderBootstrap {
    private static final Logger logger = LoggerFactory.getLogger(DashbuilderBootstrap.class);
    private String jbpmDatasource = System.getProperty("org.kie.ds.jndi", "java:jboss/datasources/ExampleDS");
    public static final String HUMAN_TASKS_DATASET = "jbpmHumanTasks";
    public static final String HUMAN_TASKS_TABLE = "AuditTaskImpl";
    public static final String PROCESS_INSTANCE_DATASET = "jbpmProcessInstances";
    public static final String PROCESS_INSTANCE_TABLE = "ProcessInstanceLog";
    public static final String HUMAN_TASKS_WITH_USER_DATASET = "jbpmHumanTasksWithUser";
    public static final String HUMAN_TASKS_WITH_ADMIN_DATASET = "jbpmHumanTasksWithAdmin";
    public static final String REQUEST_LIST_DATASET = "jbpmRequestList";
    public static final String REQUEST_LIST_TABLE = "RequestInfo";
    public static final String PROCESS_INSTANCE_WITH_VARIABLES_DATASET = "jbpmProcessInstancesWithVariables";
    public static final String TASKS_MONITORING_DATASET = "tasksMonitoring";
    public static final String PROCESSES_MONITORING_DATASET = "processesMonitoring";
    @Inject
    protected DataSetDefRegistry dataSetDefRegistry;

    @PostConstruct
    protected void init() {
        this.findDataSourceJNDI();
        this.registerDataSetDefinitions();
    }

    protected void registerDataSetDefinitions() {
        DataSetDef humanTasksDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetFactory.newSQLDataSetDef().uuid(HUMAN_TASKS_DATASET)).name("Human tasks")).dataSource(this.jbpmDatasource).dbTable(HUMAN_TASKS_TABLE, false).date("activationTime")).label("actualOwner")).label("createdBy")).date("createdOn")).label("deploymentId")).text("description")).date("dueDate")).label("name")).number("parentId")).number("priority")).label("processId")).number("processInstanceId")).number("processSessionId")).label("status")).number("taskId")).number("workItemId")).buildDef();
        DataSetDef processInstancesDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetFactory.newSQLDataSetDef().uuid(PROCESS_INSTANCE_DATASET)).name("Process Instances")).dataSource(this.jbpmDatasource).dbTable(PROCESS_INSTANCE_TABLE, false).number("processInstanceId")).label("processId")).date("start_date")).date("end_date")).number("status")).number("parentProcessInstanceId")).label("outcome")).number("duration")).label("user_identity")).label("processVersion")).label("processName")).label("correlationKey")).label("externalId")).label("processInstanceDescription")).buildDef();
        DataSetDef humanTasksWithUserDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetFactory.newSQLDataSetDef().uuid(HUMAN_TASKS_WITH_USER_DATASET)).name("Human tasks and users")).dataSource(this.jbpmDatasource).dbSQL("select  t.activationTime, t.actualOwner, t.createdBy, t.createdOn, t.deploymentId, t.description, t.dueDate, t.name, t.parentId, t.priority, t.processId, t.processInstanceId, t.processSessionId, t.status, t.taskId, t.workItemId, oe.id oeid from AuditTaskImpl t, PeopleAssignments_PotOwners po, OrganizationalEntity oe where t.taskId = po.task_id and po.entity_id = oe.id", false).date("activationTime")).label("actualOwner")).label("createdBy")).date("createdOn")).label("deploymentId")).text("description")).date("dueDate")).label("name")).number("parentId")).number("priority")).label("processId")).number("processInstanceId")).number("processSessionId")).label("status")).label("taskId")).number("workItemId")).label("oeid")).buildDef();
        DataSetDef humanTaskWithAdminDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetFactory.newSQLDataSetDef().uuid(HUMAN_TASKS_WITH_ADMIN_DATASET)).name("Human tasks and admins")).dataSource(this.jbpmDatasource).dbSQL("select t.activationTime, t.actualOwner, t.createdBy, t.createdOn, t.deploymentId, t.description, t.dueDate, t.name, t.parentId, t.priority, t.processId, t.processInstanceId, t.processSessionId, t.status, t.taskId, t.workItemId, oe.id oeid from AuditTaskImpl t, PeopleAssignments_BAs bas, OrganizationalEntity oe where t.taskId = bas.task_id and bas.entity_id = oe.id", false).date("activationTime")).label("actualOwner")).label("createdBy")).date("createdOn")).label("deploymentId")).text("description")).date("dueDate")).label("name")).number("parentId")).number("priority")).label("processId")).number("processInstanceId")).number("processSessionId")).label("status")).label("taskId")).number("workItemId")).label("oeid")).buildDef();
        DataSetDef requestListDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetFactory.newSQLDataSetDef().uuid(REQUEST_LIST_DATASET)).name("Request List")).dataSource(this.jbpmDatasource).dbTable(REQUEST_LIST_TABLE, false).number("id")).date("timestamp")).label("status")).label("commandName")).label("message")).label("businessKey")).buildDef();
        DataSetDef processWithVariablesDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetFactory.newSQLDataSetDef().uuid(PROCESS_INSTANCE_WITH_VARIABLES_DATASET)).name("Variable for Evalution Process Instances")).dataSource(this.jbpmDatasource).dbSQL("select pil.processInstanceId pid,\n       pil.processId pname,\n       v.id varid,\n       v.variableId varname,\n       v.value varvalue\nfrom ProcessInstanceLog pil\n  inner join (select vil.processInstanceId ,vil.variableId, MAX(vil.ID) maxvilid  FROM VariableInstanceLog vil\n  GROUP BY vil.processInstanceId, vil.variableId)  x\n    on (x.processInstanceId =pil.processInstanceId)\n  INNER JOIN VariableInstanceLog v\n    ON (v.variableId = x.variableId  AND v.id = x.maxvilid )", false).number("pid")).label("pname")).number("varid")).label("varname")).label("varvalue")).buildDef();
        DataSetDef processMonitoringDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetFactory.newSQLDataSetDef().uuid(PROCESSES_MONITORING_DATASET)).name("Processes monitoring")).dataSource(this.jbpmDatasource).dbTable(PROCESS_INSTANCE_TABLE, true).buildDef();
        DataSetDef taskMonitoringDef = ((SQLDataSetDefBuilderImpl)((SQLDataSetDefBuilderImpl)DataSetFactory.newSQLDataSetDef().uuid(TASKS_MONITORING_DATASET)).name("Tasks monitoring")).dataSource(this.jbpmDatasource).dbSQL("select p.processname, t.* from ProcessInstanceLog p inner join BAMTaskSummary t on (t.processInstanceId = p.processInstanceId)", true).buildDef();
        humanTasksDef.setPublic(false);
        processInstancesDef.setPublic(false);
        humanTasksWithUserDef.setPublic(false);
        humanTaskWithAdminDef.setPublic(false);
        requestListDef.setPublic(false);
        processWithVariablesDef.setPublic(false);
        processMonitoringDef.setPublic(false);
        taskMonitoringDef.setPublic(false);
        this.dataSetDefRegistry.registerDataSetDef(humanTasksDef);
        this.dataSetDefRegistry.registerDataSetDef(processInstancesDef);
        this.dataSetDefRegistry.registerDataSetDef(humanTasksWithUserDef);
        this.dataSetDefRegistry.registerDataSetDef(humanTaskWithAdminDef);
        this.dataSetDefRegistry.registerDataSetDef(requestListDef);
        this.dataSetDefRegistry.registerDataSetDef(processWithVariablesDef);
        this.dataSetDefRegistry.registerDataSetDef(processMonitoringDef);
        this.dataSetDefRegistry.registerDataSetDef(taskMonitoringDef);
    }

    protected void findDataSourceJNDI() {
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLStreamReader reader = factory.createXMLStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/persistence.xml"));
            while (reader.hasNext()) {
                int event = reader.next();
                switch (event) {
                    case 1: {
                        if (!"jta-data-source".equals(reader.getLocalName())) break;
                        this.jbpmDatasource = reader.getElementText();
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            logger.warn("Unable to find out JNDI name fo data source to be used for data sets due to {} using default {}", new Object[]{e.getMessage(), this.jbpmDatasource, e});
        }
    }
}

