/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.backend;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.shared.security.KieWorkbenchPolicy;
import org.guvnor.common.services.shared.security.KieWorkbenchSecurityService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.jbpm.console.ng.bd.service.AdministrationService;
import org.kie.internal.utils.KieMeta;
import org.kie.workbench.backend.AppSetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.services.cdi.ApplicationStarted;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.ext.security.server.RolesRegistry;

@Startup(value=StartupType.BOOTSTRAP)
@ApplicationScoped
public class AppSetup {
    private static final Logger logger = LoggerFactory.getLogger(AppSetup.class);
    private static final String OU_NAME = "demo";
    private static final String OU_OWNER = "demo@demo.org";
    private static final String JBPM_WB_PLAYGROUND_ALIAS = "jbpm-playground";
    private static final String JBPM_WB_PLAYGROUND_ORIGIN = "https://github.com/guvnorngtestuser1/jbpm-console-ng-playground-kjar.git";
    private static final String JBPM_WB_PLAYGROUND_UID = "guvnorngtestuser1";
    private static final String JBPM_WB_PLAYGROUND_PWD = "test1234";
    private static final String DROOLS_WB_PLAYGROUND_ALIAS = "uf-playground";
    private static final String DROOLS_WB_PLAYGROUND_ORIGIN = "https://github.com/guvnorngtestuser1/guvnorng-playground.git";
    private static final String DROOLS_WB_PLAYGROUND_UID = "guvnorngtestuser1";
    private static final String DROOLS_WB_PLAYGROUND_PWD = "test1234";
    private static final String GLOBAL_SETTINGS = "settings";
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private OrganizationalUnitService organizationalUnitService;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private AdministrationService administrationService;
    @Inject
    private Event<ApplicationStarted> applicationStartedEvent;
    @Inject
    private KieWorkbenchSecurityService securityService;

    @PostConstruct
    public void assertPlayground() {
        try {
            this.configurationService.startBatch();
            String exampleRepositoriesRoot = System.getProperty("org.kie.example.repositories");
            if (exampleRepositoriesRoot != null && !"".equalsIgnoreCase(exampleRepositoriesRoot)) {
                this.loadExampleRepositories(exampleRepositoriesRoot);
            } else if (!KieMeta.isProductized()) {
                if (!"false".equalsIgnoreCase(System.getProperty("org.kie.demo"))) {
                    this.administrationService.bootstrapRepository(OU_NAME, JBPM_WB_PLAYGROUND_ALIAS, JBPM_WB_PLAYGROUND_ORIGIN, "guvnorngtestuser1", "test1234");
                    this.administrationService.bootstrapRepository(OU_NAME, DROOLS_WB_PLAYGROUND_ALIAS, DROOLS_WB_PLAYGROUND_ORIGIN, "guvnorngtestuser1", "test1234");
                }
            } else if ("true".equalsIgnoreCase(System.getProperty("org.kie.example"))) {
                this.administrationService.bootstrapRepository("example", "repository1", null, "", "");
                this.administrationService.bootstrapProject("repository1", "org.kie.example", "project1", "1.0.0-SNAPSHOT");
            }
            List configGroups = this.configurationService.getConfiguration(ConfigType.GLOBAL);
            boolean globalSettingsDefined = false;
            for (ConfigGroup configGroup : configGroups) {
                if (!GLOBAL_SETTINGS.equals(configGroup.getName())) continue;
                globalSettingsDefined = true;
                ConfigItem runtimeDeployConfig = configGroup.getConfigItem("support.runtime.deploy");
                if (runtimeDeployConfig == null) {
                    configGroup.addConfigItem(this.configurationFactory.newConfigItem("support.runtime.deploy", "true"));
                    this.configurationService.updateConfiguration(configGroup);
                    break;
                }
                if (((String)runtimeDeployConfig.getValue()).equalsIgnoreCase("true")) break;
                runtimeDeployConfig.setValue((Object)"true");
                this.configurationService.updateConfiguration(configGroup);
                break;
            }
            if (!globalSettingsDefined) {
                this.configurationService.addConfiguration(this.getGlobalConfiguration());
            }
            List editorConfigGroups = this.configurationService.getConfiguration(ConfigType.EDITOR);
            boolean workItemsEditorSettingsDefined = false;
            for (ConfigGroup editorConfigGroup : editorConfigGroups) {
                if (!"work-items-editor-settings".equals(editorConfigGroup.getName())) continue;
                workItemsEditorSettingsDefined = true;
                break;
            }
            if (!workItemsEditorSettingsDefined) {
                this.configurationService.addConfiguration(this.getWorkItemElementDefinitions());
            }
            KieWorkbenchPolicy policy = new KieWorkbenchPolicy(this.securityService.loadPolicy());
            for (Map.Entry entry : policy.entrySet()) {
                if (!((String)entry.getKey()).startsWith("roles.")) continue;
                String role = (String)entry.getValue();
                RolesRegistry.get().registerRole(role);
            }
            this.administrationService.bootstrapConfig();
            this.administrationService.bootstrapDeployments();
            this.applicationStartedEvent.fire((Object)new ApplicationStarted());
        }
        catch (Exception e) {
            logger.error("Error during update config", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.configurationService.endBatch();
        }
    }

    private void loadExampleRepositories(String exampleRepositoriesRoot) {
        File root = new File(exampleRepositoriesRoot);
        if (!root.isDirectory()) {
            logger.error("System Property 'org.kie.example.repositories' does not point to a folder.");
        } else {
            logger.info("Creating Organizational Unit 'demo'.");
            OrganizationalUnit organizationalUnit = this.organizationalUnitService.getOrganizationalUnit(OU_NAME);
            if (organizationalUnit == null) {
                ArrayList repositories = new ArrayList();
                organizationalUnit = this.organizationalUnitService.createOrganizationalUnit(OU_NAME, OU_OWNER, null, repositories);
                logger.info("Created Organizational Unit 'demo'.");
            } else {
                logger.info("Organizational Unit 'demo' already exists.");
            }
            1 filter = new /* Unavailable Anonymous Inner Class!! */;
            logger.info("Cloning Example Repositories.");
            for (File child : root.listFiles((FileFilter)filter)) {
                String repositoryAlias = child.getName();
                String repositoryOrigin = child.getAbsolutePath();
                logger.info("Cloning Repository '" + repositoryAlias + "' from '" + repositoryOrigin + "'.");
                Repository repository = this.repositoryService.getRepository(repositoryAlias);
                if (repository == null) {
                    try {
                        RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
                        configurations.setOrigin(repositoryOrigin);
                        repository = this.repositoryService.createRepository("git", repositoryAlias, configurations);
                        this.organizationalUnitService.addRepository(organizationalUnit, repository);
                    }
                    catch (Exception e) {
                        logger.error("Failed to clone Repository '" + repositoryAlias + "'", (Throwable)e);
                    }
                    continue;
                }
                logger.info("Repository '" + repositoryAlias + "' already exists.");
            }
            logger.info("Example Repositories cloned.");
        }
    }

    private ConfigGroup getGlobalConfiguration() {
        ConfigGroup group = this.configurationFactory.newConfigGroup(ConfigType.GLOBAL, GLOBAL_SETTINGS, "");
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.dateformat", "dd-MMM-yyyy"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.datetimeformat", "dd-MMM-yyyy hh:mm:ss"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.defaultlanguage", "en"));
        group.addConfigItem(this.configurationFactory.newConfigItem("drools.defaultcountry", "US"));
        group.addConfigItem(this.configurationFactory.newConfigItem("build.enable-incremental", "true"));
        group.addConfigItem(this.configurationFactory.newConfigItem("rule-modeller-onlyShowDSLStatements", "false"));
        group.addConfigItem(this.configurationFactory.newConfigItem("designer.context", "designer"));
        group.addConfigItem(this.configurationFactory.newConfigItem("designer.profile", "jbpm"));
        group.addConfigItem(this.configurationFactory.newConfigItem("support.runtime.deploy", "true"));
        return group;
    }

    private ConfigGroup getWorkItemElementDefinitions() {
        ConfigGroup group = this.configurationFactory.newConfigGroup(ConfigType.EDITOR, "work-items-editor-settings", "");
        group.addConfigItem(this.configurationFactory.newConfigItem("Definition", "import org.drools.core.process.core.datatype.impl.type.StringDataType;\nimport org.drools.core.process.core.datatype.impl.type.ObjectDataType;\n\n[\n  [\n    \"name\" : \"MyTask|\", \n    \"parameters\" : [ \n        \"MyFirstParam\" : new StringDataType(), \n        \"MySecondParam\" : new StringDataType(), \n        \"MyThirdParam\" : new ObjectDataType() \n    ], \n    \"results\" : [ \n        \"Result\" : new ObjectDataType(\"java.util.Map\") \n    ], \n    \"displayName\" : \"My Task\", \n    \"icon\" : \"\" \n  ]\n]"));
        group.addConfigItem(this.configurationFactory.newConfigItem("Parameter", "\"MyParam|\" : new StringDataType()"));
        group.addConfigItem(this.configurationFactory.newConfigItem("Result", "\"Result|\" : new ObjectDataType()"));
        group.addConfigItem(this.configurationFactory.newConfigItem("DisplayName", "\"displayName\" : \"My Task|\""));
        return group;
    }
}

