/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.client.home;

import com.google.gwt.core.client.GWT;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.user.client.Window;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.guvnor.common.services.shared.security.KieWorkbenchACL;
import org.jbpm.dashboard.renderer.service.DashboardURLBuilder;
import org.kie.workbench.client.resources.i18n.HomeConstants;
import org.kie.workbench.common.screens.home.model.HomeModel;
import org.kie.workbench.common.screens.home.model.ModelUtils;
import org.kie.workbench.common.screens.home.model.Section;
import org.kie.workbench.common.screens.home.model.SectionEntry;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class HomeProducer {
    private HomeConstants constants = HomeConstants.INSTANCE;
    private HomeModel model;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private KieWorkbenchACL kieACL;

    public void init() {
        String url = GWT.getModuleBaseURL();
        this.model = new HomeModel(this.constants.homeTheKnowledgeLifeCycle());
        this.model.addCarouselEntry(ModelUtils.makeCarouselEntry((String)this.constants.homeDiscover(), (String)this.constants.homeDiscoverCaption(), (String)(url + "/images/HandHome.jpg")));
        this.model.addCarouselEntry(ModelUtils.makeCarouselEntry((String)this.constants.homeAuthor(), (String)this.constants.homeAuthorCaption(), (String)(url + "/images/HandHome.jpg")));
        this.model.addCarouselEntry(ModelUtils.makeCarouselEntry((String)this.constants.homeDeploy(), (String)this.constants.homeDeployCaption(), (String)(url + "/images/HandHome.jpg")));
        this.model.addCarouselEntry(ModelUtils.makeCarouselEntry((String)this.constants.homeWork(), (String)this.constants.homeWorkCaption(), (String)(url + "/images/HandHome.jpg")));
        this.model.addCarouselEntry(ModelUtils.makeCarouselEntry((String)this.constants.homeImprove(), (String)this.constants.homeImproveCaption(), (String)(url + "/images/HandHome.jpg")));
        Section s1 = new Section(this.constants.Authoring());
        SectionEntry s1_a = ModelUtils.makeSectionEntry((String)this.constants.Project_Authoring(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("AuthoringPerspective");
            }
        });
        SectionEntry s1_b = ModelUtils.makeSectionEntry((String)this.constants.Contributors(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("ContributorsPerspective");
            }
        });
        SectionEntry s1_d = ModelUtils.makeSectionEntry((String)this.constants.artifactRepository(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("org.guvnor.m2repo.client.perspectives.GuvnorM2RepoPerspective");
            }
        });
        SectionEntry s1_e = ModelUtils.makeSectionEntry((String)this.constants.Administration(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("AdministrationPerspective");
            }
        });
        Section s2 = new Section(this.constants.Deploy());
        SectionEntry s2_a = ModelUtils.makeSectionEntry((String)this.constants.Process_Deployments(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("Deployments");
            }
        });
        SectionEntry s2_b = ModelUtils.makeSectionEntry((String)this.constants.Rule_Deployments(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("ServerManagementPerspective");
            }
        });
        SectionEntry s2_c = ModelUtils.makeSectionEntry((String)this.constants.Jobs(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("Jobs");
            }
        });
        Section s3 = new Section(this.constants.Process_Management());
        SectionEntry s3_a = ModelUtils.makeSectionEntry((String)this.constants.Process_Definitions(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("Process Definitions");
            }
        });
        SectionEntry s3_b = ModelUtils.makeSectionEntry((String)this.constants.Process_Instances(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("DataSet Process Instances With Variables");
            }
        });
        Section s4 = new Section(this.constants.Tasks());
        SectionEntry s4_a = ModelUtils.makeSectionEntry((String)this.constants.Tasks_List(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("DataSet Tasks");
            }
        });
        Section s5 = new Section(this.constants.Dashboards());
        SectionEntry s5_a = ModelUtils.makeSectionEntry((String)this.constants.Process_Dashboard(), (Command)new Command(){

            public void execute() {
                HomeProducer.this.placeManager.goTo("DashboardPerspective");
            }
        });
        final String dashbuilderURL = DashboardURLBuilder.getDashboardURL((String)"/dashbuilder/workspace", (String)"showcase", (String)LocaleInfo.getCurrentLocale().getLocaleName());
        SectionEntry s5_b = ModelUtils.makeSectionEntry((String)this.constants.Business_Dashboard(), (Command)new Command(){

            public void execute() {
                Window.open((String)dashbuilderURL, (String)"_blank", (String)"");
            }
        });
        s1.setRoles((Collection)this.kieACL.getGrantedRoles("wb_authoring"));
        s1_a.setRoles((Collection)this.kieACL.getGrantedRoles("wb_project_authoring"));
        s1_b.setRoles((Collection)this.kieACL.getGrantedRoles("wb_contributors"));
        s1_d.setRoles((Collection)this.kieACL.getGrantedRoles("wb_artifact_repository"));
        s1_e.setRoles((Collection)this.kieACL.getGrantedRoles("wb_administration"));
        s2.setRoles((Collection)this.kieACL.getGrantedRoles("wb_deploy"));
        s2_a.setRoles((Collection)this.kieACL.getGrantedRoles("wb_deployments"));
        s2_b.setRoles((Collection)this.kieACL.getGrantedRoles("wb_management"));
        s2_c.setRoles((Collection)this.kieACL.getGrantedRoles("wb_jobs"));
        s3.setRoles((Collection)this.kieACL.getGrantedRoles("wb_process_management"));
        s3_a.setRoles((Collection)this.kieACL.getGrantedRoles("wb_process_definitions"));
        s3_b.setRoles((Collection)this.kieACL.getGrantedRoles("wb_process_instances"));
        s4.setRoles((Collection)this.kieACL.getGrantedRoles("wb_task_management"));
        s4_a.setRoles((Collection)this.kieACL.getGrantedRoles("wb_tasks"));
        s5.setRoles((Collection)this.kieACL.getGrantedRoles("wb_dashboards"));
        s5_a.setRoles((Collection)this.kieACL.getGrantedRoles("wb_process_dashboard"));
        s5_b.setRoles((Collection)this.kieACL.getGrantedRoles("wb_dashboard_builder"));
        s1.addEntry(s1_a);
        s1.addEntry(s1_b);
        s1.addEntry(s1_d);
        s1.addEntry(s1_e);
        s2.addEntry(s2_a);
        s2.addEntry(s2_b);
        s2.addEntry(s2_c);
        s3.addEntry(s3_a);
        s3.addEntry(s3_b);
        s4.addEntry(s4_a);
        s5.addEntry(s5_a);
        s5.addEntry(s5_b);
        this.model.addSection(s1);
        this.model.addSection(s2);
        this.model.addSection(s3);
        this.model.addSection(s4);
        this.model.addSection(s5);
    }

    @Produces
    public HomeModel getModel() {
        return this.model;
    }
}

