/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.client.home;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.client.home.HomeProducer;
import org.kie.workbench.common.screens.library.client.monitor.LibraryMonitor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.mvp.impl.ConditionalPlaceRequest;

@RunWith(value=GwtMockitoTestRunner.class)
public class HomeProducerTest {
    @Mock
    private PlaceManager placeManager;
    @Mock
    private LibraryMonitor libraryMonitor;
    @InjectMocks
    private HomeProducer homeProducer;

    @Test
    public void authoringRedirectsToLibraryIfThereIsNoProjectAccessibleTest() {
        ((LibraryMonitor)Mockito.doReturn((Object)false).when((Object)this.libraryMonitor)).thereIsAtLeastOneProjectAccessible();
        ConditionalPlaceRequest authoringPlaceRequest = (ConditionalPlaceRequest)this.homeProducer.getAuthoringPlaceRequest();
        Assert.assertEquals((Object)"LibraryPerspective", (Object)authoringPlaceRequest.resolveConditionalPlaceRequest().getIdentifier());
    }

    @Test
    public void authoringDoesntRedirectToLibraryIfThereIsAtLeastOneProjectAccessibleTest() {
        ((LibraryMonitor)Mockito.doReturn((Object)true).when((Object)this.libraryMonitor)).thereIsAtLeastOneProjectAccessible();
        ConditionalPlaceRequest authoringPlaceRequest = (ConditionalPlaceRequest)this.homeProducer.getAuthoringPlaceRequest();
        Assert.assertEquals((Object)"AuthoringPerspective", (Object)authoringPlaceRequest.resolveConditionalPlaceRequest().getIdentifier());
    }
}

