/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.client.home;

import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.client.home.HomeProducer;
import org.kie.workbench.common.screens.home.client.widgets.shortcut.utils.ShortcutHelper;
import org.kie.workbench.common.screens.home.model.HomeModel;
import org.kie.workbench.common.screens.home.model.HomeShortcut;
import org.kie.workbench.common.screens.home.model.HomeShortcutLink;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.client.mvp.PlaceManager;

@RunWith(value=MockitoJUnitRunner.class)
public class HomeProducerTest {
    @Mock
    private PlaceManager placeManager;
    @Mock
    private TranslationService translationService;
    @Mock
    private ShortcutHelper shortcutHelper;
    private HomeProducer producer;

    @Before
    public void setup() {
        this.producer = new HomeProducer(this.placeManager, this.translationService, this.shortcutHelper);
        ((TranslationService)Mockito.doAnswer(invocation -> invocation.getArguments()[0]).when((Object)this.translationService)).format(Matchers.anyString(), new Object[0]);
    }

    @Test
    public void checkSetupWithProvisioningGranted() {
        Mockito.when((Object)this.shortcutHelper.authorize("ProvisioningManagementPerspective")).thenReturn((Object)true);
        HomeModel model = this.producer.get();
        this.assertHomeModel(model, "DevOpsDescription2");
        this.assertDesign(model);
        this.assertManage(model);
        this.assertTrack(model);
        Assert.assertEquals((long)2L, (long)((HomeShortcut)model.getShortcuts().get(1)).getLinks().size());
        Assert.assertEquals((Object)"HomeProducer.Deployments", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(1)).getLinks().get(0)).getLabel());
        Assert.assertEquals((Object)"ProvisioningManagementPerspective", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(1)).getLinks().get(0)).getPerspectiveIdentifier());
        Assert.assertEquals((Object)"HomeProducer.Servers", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(1)).getLinks().get(1)).getLabel());
        Assert.assertEquals((Object)"ServerManagementPerspective", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(1)).getLinks().get(1)).getPerspectiveIdentifier());
    }

    @Test
    public void checkSetupWithProvisioningDenied() {
        Mockito.when((Object)this.shortcutHelper.authorize("ProvisioningManagementPerspective")).thenReturn((Object)false);
        HomeModel model = this.producer.get();
        Assert.assertNotNull((Object)model);
        this.assertHomeModel(model, "DevOpsDescription1");
        this.assertDesign(model);
        this.assertManage(model);
        this.assertTrack(model);
        Assert.assertEquals((long)1L, (long)((HomeShortcut)model.getShortcuts().get(1)).getLinks().size());
        Assert.assertEquals((Object)"HomeProducer.Servers", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(1)).getLinks().get(0)).getLabel());
        Assert.assertEquals((Object)"ServerManagementPerspective", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(1)).getLinks().get(0)).getPerspectiveIdentifier());
    }

    private void assertHomeModel(HomeModel model, String devOpsDescription) {
        Assert.assertNotNull((Object)model);
        Assert.assertEquals((Object)"Heading", (Object)model.getWelcome());
        Assert.assertEquals((Object)"SubHeading", (Object)model.getDescription());
        Assert.assertEquals((long)4L, (long)model.getShortcuts().size());
        Assert.assertEquals((Object)"Design", (Object)((HomeShortcut)model.getShortcuts().get(0)).getHeading());
        Assert.assertEquals((Object)"DesignDescription", (Object)((HomeShortcut)model.getShortcuts().get(0)).getSubHeading());
        Assert.assertEquals((Object)"DevOps", (Object)((HomeShortcut)model.getShortcuts().get(1)).getHeading());
        Assert.assertEquals((Object)devOpsDescription, (Object)((HomeShortcut)model.getShortcuts().get(1)).getSubHeading());
    }

    private void assertDesign(HomeModel model) {
        Assert.assertEquals((long)2L, (long)((HomeShortcut)model.getShortcuts().get(0)).getLinks().size());
        Assert.assertEquals((Object)"HomeProducer.Projects", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(0)).getLinks().get(0)).getLabel());
        Assert.assertEquals((Object)"LibraryPerspective", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(0)).getLinks().get(0)).getPerspectiveIdentifier());
        Assert.assertEquals((Object)"HomeProducer.Dashboards", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(0)).getLinks().get(1)).getLabel());
        Assert.assertEquals((Object)"ContentManagerPerspective", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(0)).getLinks().get(1)).getPerspectiveIdentifier());
    }

    private void assertManage(HomeModel model) {
        Assert.assertEquals((long)5L, (long)((HomeShortcut)model.getShortcuts().get(2)).getLinks().size());
        Assert.assertEquals((Object)"HomeProducer.ProcessDefinitions", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(2)).getLinks().get(0)).getLabel());
        Assert.assertEquals((Object)"ProcessDefinitions", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(2)).getLinks().get(0)).getPerspectiveIdentifier());
        Assert.assertEquals((Object)"HomeProducer.ProcessInstances", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(2)).getLinks().get(1)).getLabel());
        Assert.assertEquals((Object)"ProcessInstances", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(2)).getLinks().get(1)).getPerspectiveIdentifier());
        Assert.assertEquals((Object)"HomeProducer.TasksAdmin", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(2)).getLinks().get(2)).getLabel());
        Assert.assertEquals((Object)"TaskAdmin", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(2)).getLinks().get(2)).getPerspectiveIdentifier());
        Assert.assertEquals((Object)"HomeProducer.Jobs", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(2)).getLinks().get(3)).getLabel());
        Assert.assertEquals((Object)"Requests", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(2)).getLinks().get(3)).getPerspectiveIdentifier());
        Assert.assertEquals((Object)"HomeProducer.ExecutionErrors", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(2)).getLinks().get(4)).getLabel());
        Assert.assertEquals((Object)"ExecutionErrors", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(2)).getLinks().get(4)).getPerspectiveIdentifier());
    }

    private void assertTrack(HomeModel model) {
        Assert.assertEquals((long)3L, (long)((HomeShortcut)model.getShortcuts().get(3)).getLinks().size());
        Assert.assertEquals((Object)"HomeProducer.Tasks", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(3)).getLinks().get(0)).getLabel());
        Assert.assertEquals((Object)"Tasks", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(3)).getLinks().get(0)).getPerspectiveIdentifier());
        Assert.assertEquals((Object)"HomeProducer.Reports", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(3)).getLinks().get(1)).getLabel());
        Assert.assertEquals((Object)"DashboardPerspective", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(3)).getLinks().get(1)).getPerspectiveIdentifier());
        Assert.assertEquals((Object)"HomeProducer.BusinessDashboards", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(3)).getLinks().get(2)).getLabel());
        Assert.assertEquals((Object)"AppsPerspective", (Object)((HomeShortcutLink)((HomeShortcut)model.getShortcuts().get(3)).getLinks().get(2)).getPerspectiveIdentifier());
    }
}

