/*
 * Decompiled with CFR 0.152.
 */
package org.kie.wb.test.rest.functional;

import java.util.Collection;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.guvnor.rest.client.CreateOrCloneRepositoryRequest;
import org.guvnor.rest.client.Entity;
import org.guvnor.rest.client.JobStatus;
import org.guvnor.rest.client.RepositoryRequest;
import org.guvnor.rest.client.RepositoryResponse;
import org.junit.BeforeClass;
import org.junit.Test;
import org.kie.wb.test.rest.RestTestBase;
import org.kie.wb.test.rest.client.NotSuccessException;
import qa.tools.ikeeper.annotation.Jira;

public class RepositoryIntegrationTest
extends RestTestBase {
    private static final String ORG_UNIT = "repoTestOrgUnit";

    @BeforeClass
    public static void createOrganizationalUnit() {
        RepositoryIntegrationTest.createOrganizationalUnit(ORG_UNIT);
    }

    @Test
    public void testCreateRepositoryEmptyName() {
        RepositoryRequest repository = new RepositoryRequest();
        repository.setOrganizationalUnitName(ORG_UNIT);
        repository.setRequestType("new");
        try {
            client.createOrCloneRepository(repository);
            Assertions.fail((String)"Operation should fail because of missing repository name");
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.BAD_REQUEST);
            Assertions.assertThat((String)ex.getJobResult().getResult()).contains(new CharSequence[]{"name"});
        }
    }

    @Jira(value={"GUVNOR-2542"})
    @Test(expected=BadRequestException.class)
    public void testCreateRepositoryEmptyOrganizationalUnit() {
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("emptyOrgUnitRepo");
        repository.setRequestType("new");
        client.createOrCloneRepository(repository);
    }

    @Test(expected=BadRequestException.class)
    public void testCreateRepositoryEmptyRequestType() {
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("emptyRequestTypeRepo");
        repository.setOrganizationalUnitName(ORG_UNIT);
        client.createOrCloneRepository(repository);
    }

    private void testCreateOrCloneRepository(RepositoryRequest repository) {
        CreateOrCloneRepositoryRequest request = client.createOrCloneRepository(repository);
        Assertions.assertThat((Object)request).isNotNull();
        this.assertRepositoryRequest(request.getRepository(), repository);
        RepositoryResponse response = client.getRepository(repository.getName());
        this.assertRepositoryResponse(response, repository);
    }

    @Test
    public void testCreateRepositoryMinimal() {
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("minimalRepo");
        repository.setOrganizationalUnitName(ORG_UNIT);
        repository.setRequestType("new");
        this.testCreateOrCloneRepository(repository);
    }

    @Test
    @Jira(value={"GUVNOR-2542"})
    public void testCreateRepositoryWithDescription() {
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("repoWithDescription");
        repository.setOrganizationalUnitName(ORG_UNIT);
        repository.setRequestType("new");
        repository.setDescription("Some kind of description");
        this.testCreateOrCloneRepository(repository);
    }

    @Test
    public void testCreateRepositoryWithGitUrl() {
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("createdRepoWithGitUrl");
        repository.setOrganizationalUnitName(ORG_UNIT);
        repository.setRequestType("new");
        repository.setGitURL(RepositoryIntegrationTest.getLocalGitRepositoryUrl());
        this.testCreateOrCloneRepository(repository);
    }

    @Test
    @Jira(value={"GUVNOR-2542"})
    public void testCloneRepositoryEmptyUrl() {
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("clonedRepoWithEmptyUrl");
        repository.setOrganizationalUnitName(ORG_UNIT);
        repository.setRequestType("clone");
        try {
            client.createOrCloneRepository(repository);
            Assertions.fail((String)"Operation should fail because of missing Git URL");
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.BAD_REQUEST);
        }
    }

    @Test
    @Jira(value={"GUVNOR-2542"})
    public void testCloneRepositoryNotExistingUrl() {
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("clonedRepoWithNotExistingUrl");
        repository.setOrganizationalUnitName(ORG_UNIT);
        repository.setRequestType("clone");
        repository.setGitURL(RepositoryIntegrationTest.getLocalGitRepositoryUrl() + "xyz");
        try {
            client.createOrCloneRepository(repository);
            Assertions.fail((String)"Operation should fail because of not valid Git URL");
        }
        catch (NotSuccessException ex) {
            Assertions.assertThat((Comparable)ex.getJobResult().getStatus()).isEqualTo((Object)JobStatus.BAD_REQUEST);
        }
    }

    @Test
    public void testCloneRepositoryLocalFileSystem() {
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("clonedRemoteRepo");
        repository.setOrganizationalUnitName(ORG_UNIT);
        repository.setRequestType("clone");
        repository.setGitURL(RepositoryIntegrationTest.getLocalGitRepositoryUrl());
        this.testCreateOrCloneRepository(repository);
    }

    @Test
    public void testCloneRepositoryInternal() {
        String originalRepo = "repoToBeCloned";
        RepositoryIntegrationTest.createNewRepository(ORG_UNIT, originalRepo);
        RepositoryRequest repository = new RepositoryRequest();
        repository.setName("clonedInternalRepo");
        repository.setOrganizationalUnitName(ORG_UNIT);
        repository.setRequestType("clone");
        repository.setGitURL("git://localhost:9418/" + originalRepo);
        this.testCreateOrCloneRepository(repository);
    }

    @Test
    public void testDeleteRepository() {
        String name = "repoToBeDeleted";
        RepositoryIntegrationTest.createNewRepository(ORG_UNIT, name);
        client.deleteRepository(name);
        try {
            client.getRepository(name);
            Assertions.fail((String)"Repository should have been deleted");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Jira(value={"GUVNOR-2542"})
    @Test(expected=NotFoundException.class)
    public void testDeleteRepositoryNotExisting() {
        client.deleteRepository("notExistingRepo");
    }

    @Test
    public void testGetExistingRepository() {
        String name = "getExistingRepo";
        RepositoryIntegrationTest.createNewRepository(ORG_UNIT, name);
        RepositoryResponse repository = client.getRepository(name);
        Assertions.assertThat((String)repository.getName()).isEqualTo((Object)name);
    }

    @Test(expected=NotFoundException.class)
    public void testGetNotExistingRepository() {
        client.getRepository("notExistingRepo");
    }

    @Test
    public void testGetRepositories() {
        String name = "oneOfManyRepos";
        RepositoryIntegrationTest.createNewRepository(ORG_UNIT, name);
        Collection repositories = client.getRepositories();
        Assertions.assertThat((Iterable)repositories).extracting(Entity::getName).contains((Object[])new String[]{name});
    }

    private void assertRepositoryRequest(RepositoryRequest actual, RepositoryRequest expected) {
        Assertions.assertThat((Object)actual).isNotNull();
        SoftAssertions assertions = new SoftAssertions();
        assertions.assertThat(actual.getName()).isEqualTo((Object)expected.getName());
        assertions.assertThat(actual.getDescription()).isEqualTo((Object)expected.getDescription());
        assertions.assertThat(actual.getOrganizationalUnitName()).isEqualTo((Object)expected.getOrganizationalUnitName());
        assertions.assertThat(actual.getUserName()).isEqualTo((Object)expected.getUserName());
        assertions.assertThat(actual.getPassword()).isEqualTo((Object)expected.getPassword());
        assertions.assertThat(actual.getRequestType()).isEqualTo((Object)expected.getRequestType());
        assertions.assertThat(actual.getGitURL()).isEqualTo((Object)expected.getGitURL());
        assertions.assertAll();
    }

    private void assertRepositoryResponse(RepositoryResponse actual, RepositoryRequest expected) {
        Assertions.assertThat((Object)actual).isNotNull();
        SoftAssertions assertions = new SoftAssertions();
        assertions.assertThat(actual.getName()).isEqualTo((Object)expected.getName());
        assertions.assertThat(actual.getDescription()).isEqualTo((Object)expected.getDescription());
        assertions.assertThat(actual.getUserName()).isEqualTo((Object)expected.getUserName());
        assertions.assertThat(actual.getPassword()).isEqualTo((Object)expected.getPassword());
        assertions.assertThat(actual.getRequestType()).isNull();
        assertions.assertAll();
    }
}

