/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench;

import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.junit.Assert;
import org.junit.Test;
import org.reflections.Reflections;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestApiJspTest {
    private static final Logger logger = LoggerFactory.getLogger(RestApiJspTest.class);
    private static final Reflections reflections = new Reflections(new Object[]{ClasspathHelper.forPackage((String)"org.guvnor.rest", (ClassLoader[])new ClassLoader[0]), ClasspathHelper.forPackage((String)"org.kie.remote.services.rest", (ClassLoader[])new ClassLoader[0]), new TypeAnnotationsScanner(), new FieldAnnotationsScanner(), new SubTypesScanner()});
    private static final Class[] restMethodAnnosArr = new Class[]{GET.class, POST.class, DELETE.class, PUT.class};
    private static final Pattern restParamPattern = Pattern.compile("\\{(\\w+): ([^\\/]+)\\}+");
    private static final String SPLIT_CHAR = "#";

    private RestMethodInfo getRestMethodInfo() throws Exception {
        HashSet<Class> restMethodAnnos = new HashSet<Class>(Arrays.asList(restMethodAnnosArr));
        Set resourceImplClasses = reflections.getTypesAnnotatedWith(Path.class);
        HashMap<Object, String> resourceMethods = new HashMap<Object, String>();
        for (Class resourceImplClass : resourceImplClasses) {
            for (Method possibleRestMethod : resourceImplClass.getDeclaredMethods()) {
                for (Annotation anno : possibleRestMethod.getAnnotations()) {
                    if (!restMethodAnnos.contains(anno.annotationType())) continue;
                    resourceMethods.put(possibleRestMethod, anno.annotationType().getSimpleName());
                }
            }
        }
        RestMethodInfo restInfo = new RestMethodInfo();
        HashMap<String, String> paramDefinitions = new HashMap<String, String>();
        for (Map.Entry entry : resourceMethods.entrySet()) {
            Path methodPathAnno;
            Method restMethod = (Method)entry.getKey();
            String basePath = restMethod.getDeclaringClass().getAnnotation(Path.class).value();
            if (basePath.endsWith("/")) {
                basePath = basePath.substring(0, basePath.length() - 1);
            }
            String methodPath = (methodPathAnno = restMethod.getAnnotation(Path.class)) == null ? "" : methodPathAnno.value();
            String restOperPath = basePath + methodPath;
            Matcher m = restParamPattern.matcher(restOperPath);
            while (m.find()) {
                String fullParam = m.group();
                Assert.assertEquals((String)"Bug in test: there should be 2 groups!", (long)2L, (long)m.groupCount());
                String paramName = m.group(1);
                String paramRegex = m.group(2);
                restInfo.addRestUrlParameterDefinition(restOperPath, paramName, paramRegex);
                String prevParamRegex = paramDefinitions.put(paramName, paramRegex);
                Assert.assertTrue((String)("Unequal param definition for '" + paramName + "' : [" + paramRegex + "/" + prevParamRegex + "]"), (prevParamRegex == null || paramRegex.equals(prevParamRegex) ? 1 : 0) != 0);
                restOperPath = restOperPath.replace(fullParam, "{" + paramName + "}");
            }
            restInfo.addRestOperation(restOperPath, (String)entry.getValue());
        }
        return restInfo;
    }

    @Test
    public void restApiJspCorrectReferencesAllRestOperations() throws Exception {
        Properties testProps = new Properties();
        String testPropFile = "/test.properties";
        InputStream propIn = this.getClass().getResourceAsStream("/test.properties");
        Assert.assertNotNull((String)("Unable to find and read " + testPropFile), (Object)propIn);
        testProps.load(propIn);
        String baseDir = testProps.getProperty("baseDir");
        String restApiJspPath = baseDir + "/src/main/webapp/rest-api.jsp";
        File restApiJspFile = new File(restApiJspPath);
        Assert.assertTrue((String)("rest-api.jsp not found at " + restApiJspPath), (boolean)restApiJspFile.exists());
        Document restApiJspDoc = Jsoup.parse((File)restApiJspFile, (String)"UTF-8", (String)"http://localhost:8080/kie-wb/");
        Assert.assertNotNull((String)"Could not parse rest-api.jsp with JSoup", (Object)restApiJspDoc);
        RestMethodInfo restInfo = this.getRestMethodInfo();
        Set<String> restPathOperations = restInfo.getRestPathOperations();
        HashSet<String> jspPaths = new HashSet<String>(restPathOperations.size());
        HashSet<String> restPaths = new HashSet<String>();
        for (String restPathOper : restInfo.getRestPathOperations()) {
            String[] restPathInfo = restPathOper.split(SPLIT_CHAR);
            restPaths.add(restPathInfo[0]);
        }
        TreeMap<String, String> jspParams = new TreeMap<String, String>();
        TreeMap paramDefs = new TreeMap();
        for (Map iterator : restInfo.getRestUrlParameterDefs().values()) {
            for (Map.Entry entry : iterator.entrySet()) {
                String prevValue = (String)paramDefs.put(entry.getKey(), entry.getValue());
                if (prevValue == null) continue;
                Assert.assertEquals((String)("Different values for parameter " + (String)entry.getKey()), (Object)prevValue, entry.getValue());
            }
        }
        for (Map.Entry entry : paramDefs.entrySet()) {
        }
        Elements tables = restApiJspDoc.body().getElementsByTag("table");
        Assert.assertFalse((boolean)tables.isEmpty());
        for (Element element : tables) {
            Elements rows = element.getElementsByTag("tr");
            for (Element row : rows) {
                String text;
                String idAttr = element.attr("id");
                if ("parameters".equals(idAttr)) {
                    String[] paramDef = new String[2];
                    for (Element cell : row.getElementsByTag("td")) {
                        text = cell.text();
                        if (text.startsWith("[")) {
                            paramDef[1] = text;
                        } else if (!text.contains(" ")) {
                            paramDef[0] = text;
                        }
                        if (paramDef[1] == null || paramDef[1] == null) continue;
                        jspParams.put(paramDef[0], paramDef[1]);
                        Assert.assertTrue((String)("Unknown param definition: [" + paramDef[0] + "]"), (boolean)paramDefs.containsKey(paramDef[0]));
                        Assert.assertEquals((String)("Incorrect param definition: [" + paramDef[0] + "]"), paramDefs.get(paramDef[0]), (Object)paramDef[1]);
                    }
                    continue;
                }
                String[] restPathOp = new String[2];
                for (Element cell : row.getElementsByTag("td")) {
                    text = cell.text();
                    if (text.startsWith("/")) {
                        jspPaths.add(text);
                        restPathOp[1] = text;
                        continue;
                    }
                    if (!text.matches("[A-Z]+")) continue;
                    restPathOp[0] = text;
                }
                if (restPathOp[1] == null) continue;
                Assert.assertNotNull((String)("No HTTP operation provided for [" + restPathOp[1] + "]"), (Object)restPathOp[0]);
                Assert.assertTrue((String)("[" + restPathOp[0] + "] is an incorrect REST operation path for " + restPathOp[1]), (boolean)restPaths.contains(restPathOp[1]));
                Assert.assertTrue((String)("Incorrect HTTP operation for [" + restPathOp[1] + "]"), (boolean)restInfo.getRestPathOperations().contains(restPathOp[1] + SPLIT_CHAR + restPathOp[0]));
            }
        }
        for (String string : restPaths) {
            Assert.assertTrue((String)("[" + string + "] is not shown in the JSP."), (boolean)jspPaths.contains(string));
        }
        for (Map.Entry entry : paramDefs.entrySet()) {
            Assert.assertTrue((String)("Parameter [" + (String)entry.getKey() + "] is not definied in the JSP."), (boolean)jspParams.containsKey(entry.getKey()));
            Assert.assertEquals((String)("Parameter [" + (String)entry.getKey() + "] is not correctly defined in the JSP."), entry.getValue(), jspParams.get(entry.getKey()));
        }
    }

    private static final class RestMethodInfo {
        private Set<String> restPathOperations = new TreeSet<String>();
        private Map<String, Map<String, String>> restUrlParameterDefs = new HashMap<String, Map<String, String>>();

        private RestMethodInfo() {
        }

        public Set<String> getRestPathOperations() {
            return this.restPathOperations;
        }

        public void addRestOperation(String restOperPath, String restOper) {
            this.restPathOperations.add(restOperPath + RestApiJspTest.SPLIT_CHAR + restOper);
        }

        public Map<String, Map<String, String>> getRestUrlParameterDefs() {
            return this.restUrlParameterDefs;
        }

        public void addRestUrlParameterDefinition(String url, String paramName, String paramRegex) {
            Map<String, String> paramNameRegexMap = this.restUrlParameterDefs.get(url);
            if (paramNameRegexMap == null) {
                paramNameRegexMap = new HashMap<String, String>(2);
                this.restUrlParameterDefs.put(url, paramNameRegexMap);
            }
            String prevRegex = paramNameRegexMap.put(paramName, paramRegex);
            Assert.assertTrue((String)("Regex in url has 2 different definitions [" + url + "]"), (prevRegex == null || prevRegex.equals(paramRegex) ? 1 : 0) != 0);
        }
    }
}

