/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.backend;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.backend.LogoutHelper;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class LogoutHelperTest {
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private HttpSession session;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.request.getSession(Mockito.anyBoolean())).thenReturn((Object)this.session);
    }

    @Test
    public void testLogout() throws Exception {
        LogoutHelper.logout((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        ((HttpServletRequest)Mockito.verify((Object)this.request)).logout();
        ((HttpSession)Mockito.verify((Object)this.session)).invalidate();
        ArgumentCaptor cookieCaptor = ArgumentCaptor.forClass(Cookie.class);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addCookie((Cookie)cookieCaptor.capture());
        Cookie cookie = (Cookie)cookieCaptor.getValue();
        Assert.assertEquals((Object)cookie.getName(), (Object)"JSESSIONID");
        Assert.assertEquals((Object)cookie.getPath(), (Object)"/dashbuilder");
        Assert.assertEquals((Object)cookie.getValue(), null);
    }
}

