/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.dashbuilder.client.cms.screen.explorer.NavigationExplorerScreen;
import org.dashbuilder.client.navigation.NavigationManager;
import org.dashbuilder.client.navigation.event.NavTreeLoadedEvent;
import org.dashbuilder.client.navigation.impl.NavigationManagerImpl;
import org.dashbuilder.client.navigation.widget.editor.NavTreeEditor;
import org.dashbuilder.client.navigation.widget.editor.NavTreeEditorView;
import org.dashbuilder.client.navigation.widget.editor.TargetPerspectiveEditor;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavTree;
import org.dashbuilder.navigation.service.NavigationServices;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.client.KieWorkbenchEntryPoint;
import org.kie.workbench.client.navigation.NavTreeDefinitions;
import org.kie.workbench.client.resources.i18n.NavigationConstants;
import org.kie.workbench.common.workbench.client.admin.DefaultAdminPageHelper;
import org.kie.workbench.common.workbench.client.authz.PermissionTreeSetup;
import org.kie.workbench.common.workbench.client.menu.DefaultWorkbenchFeaturesMenusHelper;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.client.authz.PerspectiveTreeProvider;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.workbench.Workbench;
import org.uberfire.client.workbench.widgets.menu.megamenu.WorkbenchMegaMenuPresenter;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class KieWorkbenchEntryPointTest {
    @Mock
    private AppConfigService appConfigService;
    @Mock
    private ActivityBeansCache activityBeansCache;
    @Mock
    private DefaultWorkbenchFeaturesMenusHelper menusHelper;
    @Mock
    protected ClientUserSystemManager userSystemManager;
    @Mock
    protected WorkbenchMegaMenuPresenter menuBar;
    @Mock
    protected Workbench workbench;
    @Mock
    protected PermissionTreeSetup permissionTreeSetup;
    @Mock
    private PerspectiveTreeProvider perspectiveTreeProvider;
    @Mock
    private SyncBeanManager syncBeanManager;
    @Mock
    private DefaultAdminPageHelper adminPageHelper;
    private NavTreeDefinitions navTreeDefinitions;
    private NavigationManager navigationManager;
    @Mock
    protected NavigationExplorerScreen navigationExplorerScreen;
    @Mock
    protected NavigationConstants navigationConstants;
    @Mock
    protected NavigationServices navigationServices;
    @Mock
    protected NavTreeEditor navTreeEditor;
    @Mock
    protected TargetPerspectiveEditor targetPerspectiveEditor;
    @Mock
    protected EventSourceMock<NavTreeLoadedEvent> navTreeLoadedEvent;
    private KieWorkbenchEntryPoint kieWorkbenchEntryPoint;

    @Before
    public void setup() {
        this.navTreeDefinitions = new NavTreeDefinitions();
        this.navigationManager = new NavigationManagerImpl((Caller)new CallerMock((Object)this.navigationServices), null, this.navTreeLoadedEvent, null, null);
        ((ClientUserSystemManager)Mockito.doAnswer(invocationOnMock -> {
            ((Command)invocationOnMock.getArguments()[0]).execute();
            return null;
        }).when((Object)this.userSystemManager)).waitForInitialization((Command)Mockito.any(Command.class));
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.doReturn((Object)Mockito.mock(MenuFactory.TopLevelMenusBuilder.class)).when((Object)this.menusHelper)).buildMenusFromNavTree((NavTree)Mockito.any());
        CallerMock appConfigServiceCallerMock = new CallerMock((Object)this.appConfigService);
        this.kieWorkbenchEntryPoint = (KieWorkbenchEntryPoint)Mockito.spy((Object)new KieWorkbenchEntryPoint((Caller)appConfigServiceCallerMock, this.activityBeansCache, this.menusHelper, this.userSystemManager, this.menuBar, this.workbench, this.permissionTreeSetup, this.adminPageHelper, this.navTreeDefinitions, this.navigationManager, this.navigationExplorerScreen));
        ((KieWorkbenchEntryPoint)Mockito.doNothing().when((Object)this.kieWorkbenchEntryPoint)).hideLoadingPopup();
        this.navTreeEditor = (NavTreeEditor)Mockito.spy((Object)new NavTreeEditor((NavTreeEditorView)Mockito.mock(NavTreeEditorView.class), null, this.syncBeanManager, null, this.perspectiveTreeProvider, this.targetPerspectiveEditor, null, null, null, null));
        Mockito.when((Object)this.navigationExplorerScreen.getNavTreeEditor()).thenReturn((Object)this.navTreeEditor);
    }

    @Test
    public void initTest() {
        this.kieWorkbenchEntryPoint.init();
        ((Workbench)Mockito.verify((Object)this.workbench)).addStartupBlocker(KieWorkbenchEntryPoint.class);
        ((PermissionTreeSetup)Mockito.verify((Object)this.permissionTreeSetup)).configureTree();
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setMaxLevels("wb_group", 2);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setNewDividerEnabled("wb_group", false);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setNewPerspectiveEnabled("wb_group", false);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setOnlyRuntimePerspectives("wb_group", false);
        ((NavTreeEditor)Mockito.verify((Object)this.navTreeEditor)).setPerspectiveContextEnabled("wb_group", false);
    }

    @Test
    public void setupMenuTest() {
        this.kieWorkbenchEntryPoint.setupMenu();
        ((WorkbenchMegaMenuPresenter)Mockito.verify((Object)this.menuBar)).addMenus((Menus)Mockito.any());
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addUtilitiesMenuItems();
        ((Workbench)Mockito.verify((Object)this.workbench)).removeStartupBlocker(KieWorkbenchEntryPoint.class);
    }

    @Test
    public void defaultNavTreeTest() {
        this.kieWorkbenchEntryPoint.setupMenu();
        NavTree navTree = this.navigationManager.getNavTree();
        NavGroup workbench = (NavGroup)navTree.getItemById("wb_group");
        NavGroup design = (NavGroup)navTree.getItemById("wb_group_design");
        NavItem projects = navTree.getItemById("wb_entry_projects");
        NavItem pages = navTree.getItemById("wb_entry_pages");
        NavGroup deploy = (NavGroup)navTree.getItemById("wb_group_deploy");
        NavItem execServers = navTree.getItemById("wb_entry_execution_servers");
        NavGroup manage = (NavGroup)navTree.getItemById("wb_group_manage");
        NavItem processDef = navTree.getItemById("wb_entry_process_definitions");
        NavItem processInst = navTree.getItemById("wb_entry_process_instances");
        NavItem taskAdmin = navTree.getItemById("wb_entry_task_administration");
        NavItem jobs = navTree.getItemById("wb_entry_jobs");
        NavItem executionErrors = navTree.getItemById("wb_execution_errors");
        NavGroup track = (NavGroup)navTree.getItemById("wb_group_track");
        NavItem tasks = navTree.getItemById("wb_entry_tasks_list");
        NavItem processDashboard = navTree.getItemById("wb_entry_process_dashboard");
        NavItem taskDashboard = navTree.getItemById("wb_entry_task_dashboard");
        Assert.assertNotNull((Object)workbench);
        Assert.assertNotNull((Object)design);
        Assert.assertNotNull((Object)deploy);
        Assert.assertNotNull((Object)manage);
        Assert.assertNotNull((Object)track);
        Assert.assertEquals((Object)design.getParent(), (Object)workbench);
        Assert.assertEquals((Object)deploy.getParent(), (Object)workbench);
        Assert.assertEquals((Object)manage.getParent(), (Object)workbench);
        Assert.assertEquals((Object)track.getParent(), (Object)workbench);
        Assert.assertNotNull((Object)projects);
        Assert.assertNotNull((Object)pages);
        Assert.assertEquals((Object)projects.getParent(), (Object)design);
        Assert.assertEquals((Object)pages.getParent(), (Object)design);
        Assert.assertNotNull((Object)execServers);
        Assert.assertEquals((Object)execServers.getParent(), (Object)deploy);
        Assert.assertNotNull((Object)processDef);
        Assert.assertNotNull((Object)processInst);
        Assert.assertNotNull((Object)taskAdmin);
        Assert.assertNotNull((Object)jobs);
        Assert.assertNotNull((Object)executionErrors);
        Assert.assertEquals((Object)processDef.getParent(), (Object)manage);
        Assert.assertEquals((Object)processInst.getParent(), (Object)manage);
        Assert.assertEquals((Object)taskAdmin.getParent(), (Object)manage);
        Assert.assertEquals((Object)jobs.getParent(), (Object)manage);
        Assert.assertEquals((Object)executionErrors.getParent(), (Object)manage);
        Assert.assertNotNull((Object)tasks);
        Assert.assertNotNull((Object)processDashboard);
        Assert.assertNotNull((Object)taskDashboard);
        Assert.assertEquals((Object)tasks.getParent(), (Object)track);
        Assert.assertEquals((Object)processDashboard.getParent(), (Object)track);
        Assert.assertEquals((Object)taskDashboard.getParent(), (Object)track);
    }
}

