/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.endpoint.bootstrap;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Map;
import org.kie.hacep.EnvConfig;
import org.kie.hacep.core.Bootstrap;
import org.kie.hacep.core.GlobalStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkHttpServer {
    private static final String OK = "OK";
    private static final String KO = "KO";
    private static Logger logger = LoggerFactory.getLogger(JdkHttpServer.class);

    public static void main(String[] args) throws Exception {
        HttpServer server = HttpServer.create(new InetSocketAddress(8080), 0);
        server.createContext("/readiness", new ReadinessHandler());
        server.createContext("/liveness", new LivenessHandler());
        server.createContext("/env/all", new EnvHandler());
        server.start();
        Bootstrap.startEngine((EnvConfig)EnvConfig.getDefaultEnvConfig());
        logger.info("Core system started");
        Runtime.getRuntime().addShutdownHook(new Thread(Bootstrap::stopEngine));
    }

    private static void initResponse(HttpExchange httpExchange, boolean isOk) throws IOException {
        int returnCode = isOk ? 200 : 400;
        int returnLength = isOk ? OK.length() : KO.length();
        byte[] returnBytes = isOk ? OK.getBytes() : KO.getBytes();
        httpExchange.sendResponseHeaders(returnCode, returnLength);
        OutputStream os = httpExchange.getResponseBody();
        os.write(returnBytes);
        os.close();
    }

    private static class EnvHandler
    implements HttpHandler {
        private EnvHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            StringBuilder sb = new StringBuilder();
            Map<String, String> env = System.getenv();
            for (Map.Entry<String, String> entry : env.entrySet()) {
                sb.append(entry.getKey()).append(":").append(entry.getValue()).append("\n");
            }
            String result = sb.toString();
            httpExchange.sendResponseHeaders(200, result.length());
            OutputStream os = httpExchange.getResponseBody();
            os.write(result.getBytes());
            os.close();
        }
    }

    static class LivenessHandler
    implements HttpHandler {
        LivenessHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            JdkHttpServer.initResponse(httpExchange, GlobalStatus.nodeLive);
        }
    }

    static class ReadinessHandler
    implements HttpHandler {
        ReadinessHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            JdkHttpServer.initResponse(httpExchange, GlobalStatus.nodeReady);
        }
    }
}

