/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.mining.compiler.factories;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.DoubleLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Field;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.Model;
import org.dmg.pmml.Output;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.TransformationDictionary;
import org.dmg.pmml.mining.Segment;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.model.HasSourcesMap;
import org.kie.pmml.commons.model.KiePMMLModel;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLModelFactoryUtils;
import org.kie.pmml.compiler.commons.codegenfactories.KiePMMLPredicateFactory;
import org.kie.pmml.compiler.commons.implementations.KiePMMLModelRetriever;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLSegmentFactory {
    static final String KIE_PMML_SEGMENT_TEMPLATE_JAVA = "KiePMMLSegmentTemplate.tmpl";
    static final String KIE_PMML_SEGMENT_TEMPLATE = "KiePMMLSegmentTemplate";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLSegmentFactory.class.getName());
    private static final String GET_SEGMENTS = "getSegments {}";
    private static final String GET_SEGMENT = "getSegment {}";
    private static final String GET_PREDICATE = "getPredicate";
    private static final String PREDICATE = "predicate";

    private KiePMMLSegmentFactory() {
    }

    public static Map<String, String> getSegmentsSourcesMap(String parentPackageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, List<Segment> segments, HasClassLoader hasClassloader, List<KiePMMLModel> nestedModels) {
        logger.debug(GET_SEGMENTS, segments);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        segments.forEach(segment -> toReturn.putAll(KiePMMLSegmentFactory.getSegmentSourcesMap(parentPackageName, fields, transformationDictionary, segment, hasClassloader, nestedModels)));
        return toReturn;
    }

    public static Map<String, String> getSegmentsSourcesMapCompiled(String parentPackageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, List<Segment> segments, HasClassLoader hasClassloader, List<KiePMMLModel> nestedModels) {
        logger.debug(GET_SEGMENTS, segments);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        segments.forEach(segment -> toReturn.putAll(KiePMMLSegmentFactory.getSegmentSourcesMapCompiled(parentPackageName, fields, transformationDictionary, segment, hasClassloader, nestedModels)));
        return toReturn;
    }

    public static Map<String, String> getSegmentSourcesMap(String parentPackageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, Segment segment, HasClassLoader hasClassloader, List<KiePMMLModel> nestedModels) {
        logger.debug(GET_SEGMENT, (Object)segment);
        String packageName = KiePMMLModelUtils.getSanitizedPackageName((String)(parentPackageName + "." + segment.getId()));
        KiePMMLModel nestedModel = (KiePMMLModel)KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSources((String)packageName, fields, (TransformationDictionary)transformationDictionary, (Model)segment.getModel(), (HasClassLoader)hasClassloader).orElseThrow(() -> new KiePMMLException("Failed to get the KiePMMLModel for segment " + segment.getModel().getModelName()));
        Map<String, String> toReturn = KiePMMLSegmentFactory.getSegmentSourcesMapCommon(parentPackageName, fields, segment, nestedModels, nestedModel);
        KiePMMLSegmentFactory.populateFieldsWithModelOnes(fields, segment.getModel());
        return toReturn;
    }

    public static Map<String, String> getSegmentSourcesMapCompiled(String parentPackageName, List<Field<?>> fields, TransformationDictionary transformationDictionary, Segment segment, HasClassLoader hasClassloader, List<KiePMMLModel> nestedModels) {
        logger.debug(GET_SEGMENT, (Object)segment);
        String packageName = KiePMMLModelUtils.getSanitizedPackageName((String)(parentPackageName + "." + segment.getId()));
        KiePMMLModel nestedModel = (KiePMMLModel)KiePMMLModelRetriever.getFromCommonDataAndTransformationDictionaryAndModelWithSourcesCompiled((String)packageName, fields, (TransformationDictionary)transformationDictionary, (Model)segment.getModel(), (HasClassLoader)hasClassloader).orElseThrow(() -> new KiePMMLException("Failed to get the KiePMMLModel for segment " + segment.getModel().getModelName()));
        Map<String, String> toReturn = KiePMMLSegmentFactory.getSegmentSourcesMapCommon(parentPackageName, fields, segment, nestedModels, nestedModel);
        KiePMMLSegmentFactory.populateFieldsWithModelOnes(fields, segment.getModel());
        return toReturn;
    }

    static Map<String, String> getSegmentSourcesMapCommon(String parentPackageName, List<Field<?>> fields, Segment segment, List<KiePMMLModel> nestedModels, KiePMMLModel nestedModel) {
        logger.debug(GET_SEGMENT, (Object)segment);
        String packageName = KiePMMLModelUtils.getSanitizedPackageName((String)(parentPackageName + "." + segment.getId()));
        if (!(nestedModel instanceof HasSourcesMap)) {
            throw new KiePMMLException("Retrieved KiePMMLModel for segment " + segment.getModel().getModelName() + " does not implement HasSources");
        }
        nestedModels.add(nestedModel);
        return KiePMMLSegmentFactory.getSegmentSourcesMap(packageName, fields, segment);
    }

    static void populateFieldsWithModelOnes(List<Field<?>> fields, Model model) {
        fields.addAll(KiePMMLSegmentFactory.getFieldsFromModel(model));
    }

    static Map<String, String> getSegmentSourcesMap(String packageName, List<Field<?>> fields, Segment segment) {
        logger.debug(GET_SEGMENT, (Object)segment);
        String kiePmmlModelPackage = KiePMMLModelUtils.getSanitizedPackageName((String)String.format("%s.%s", packageName, segment.getModel().getModelName()));
        String kiePMMLModelClass = kiePmmlModelPackage + "." + KiePMMLModelUtils.getSanitizedClassName((String)segment.getModel().getModelName());
        String className = KiePMMLModelUtils.getSanitizedClassName((String)segment.getId());
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)className, (String)packageName, (String)KIE_PMML_SEGMENT_TEMPLATE_JAVA, (String)KIE_PMML_SEGMENT_TEMPLATE);
        ClassOrInterfaceDeclaration segmentTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(className).orElseThrow(() -> new KiePMMLException("Main class not found: " + className));
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)segmentTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", segmentTemplate.getName())));
        HashMap<String, String> toReturn = new HashMap<String, String>();
        KiePMMLSegmentFactory.setConstructor(segment.getId(), className, constructorDeclaration, kiePMMLModelClass, segment.getWeight().doubleValue());
        KiePMMLSegmentFactory.populateGetPredicateMethod(segment.getPredicate(), fields, segmentTemplate);
        toReturn.put(JavaParserUtils.getFullClassName((CompilationUnit)cloneCU), cloneCU.toString());
        return toReturn;
    }

    static void setConstructor(String segmentName, String generatedClassName, ConstructorDeclaration constructorDeclaration, String kiePMMLModelClass, double weight) {
        KiePMMLModelFactoryUtils.setConstructorSuperNameInvocation((String)generatedClassName, (ConstructorDeclaration)constructorDeclaration, (String)segmentName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = (ExplicitConstructorInvocationStmt)CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        ClassOrInterfaceType classOrInterfaceType = StaticJavaParser.parseClassOrInterfaceType((String)kiePMMLModelClass);
        ObjectCreationExpr objectCreationExpr = new ObjectCreationExpr();
        objectCreationExpr.setType(classOrInterfaceType);
        CommonCodegenUtils.setExplicitConstructorInvocationStmtArgument((ExplicitConstructorInvocationStmt)superStatement, (String)"model", (String)objectCreationExpr.toString());
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"weight", (Expression)new DoubleLiteralExpr(weight));
        CommonCodegenUtils.setAssignExpressionValue((BlockStmt)body, (String)"id", (Expression)new StringLiteralExpr(segmentName));
    }

    static void populateGetPredicateMethod(Predicate predicate, List<Field<?>> fields, ClassOrInterfaceDeclaration segmentTemplate) {
        BlockStmt toSet = KiePMMLPredicateFactory.getKiePMMLPredicate((String)PREDICATE, (Predicate)predicate, fields);
        toSet.addStatement((Statement)new ReturnStmt(PREDICATE));
        MethodDeclaration methodDeclaration = (MethodDeclaration)segmentTemplate.getMethodsByName(GET_PREDICATE).get(0);
        methodDeclaration.setBody(toSet);
    }

    static List<Field<?>> getFieldsFromModel(Model model) {
        Output output;
        ArrayList toReturn = new ArrayList();
        LocalTransformations localTransformations = model.getLocalTransformations();
        if (localTransformations != null && localTransformations.hasDerivedFields()) {
            localTransformations.getDerivedFields().stream().map(Field.class::cast).forEach(toReturn::add);
        }
        if ((output = model.getOutput()) != null && output.hasOutputFields()) {
            output.getOutputFields().stream().map(Field.class::cast).forEach(toReturn::add);
        }
        return toReturn;
    }
}

