/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.scorecard.compiler.factories;

import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ExplicitConstructorInvocationStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dmg.pmml.Field;
import org.dmg.pmml.scorecard.Characteristic;
import org.dmg.pmml.scorecard.Characteristics;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.api.exceptions.KiePMMLInternalException;
import org.kie.pmml.commons.model.HasClassLoader;
import org.kie.pmml.commons.utils.KiePMMLModelUtils;
import org.kie.pmml.compiler.commons.utils.CommonCodegenUtils;
import org.kie.pmml.compiler.commons.utils.JavaParserUtils;
import org.kie.pmml.models.scorecard.compiler.factories.KiePMMLCharacteristicFactory;
import org.kie.pmml.models.scorecard.model.KiePMMLCharacteristic;
import org.kie.pmml.models.scorecard.model.KiePMMLCharacteristics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLCharacteristicsFactory {
    static final String KIE_PMML_CHARACTERISTICS_TEMPLATE_JAVA = "KiePMMLCharacteristicsTemplate.tmpl";
    static final String KIE_PMML_CHARACTERISTICS_TEMPLATE = "KiePMMLCharacteristicsTemplate";
    static final String GETKIEPMMLCHARACTERISTICS = "getKiePMMLCharacteristics";
    static final String CHARACTERISTICS = "characteristics";
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLCharacteristicsFactory.class.getName());

    private KiePMMLCharacteristicsFactory() {
    }

    public static KiePMMLCharacteristics getKiePMMLCharacteristics(Characteristics characteristics, List<Field<?>> fields, String packageName, HasClassLoader hasClassLoader) {
        logger.trace("getKiePMMLCharacteristics {} {}", (Object)packageName, (Object)characteristics);
        String className = KiePMMLModelUtils.getGeneratedClassName((String)"Characteristics");
        String fullClassName = packageName + "." + className;
        Map<String, String> sourcesMap = KiePMMLCharacteristicsFactory.getKiePMMLCharacteristicsSourcesMap(characteristics, fields, className, packageName);
        try {
            Class kiePMMLCharacteristicsClass = hasClassLoader.compileAndLoadClass(sourcesMap, fullClassName);
            return (KiePMMLCharacteristics)kiePMMLCharacteristicsClass.newInstance();
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    static Map<String, String> getKiePMMLCharacteristicsSourcesMap(Characteristics characteristics, List<Field<?>> fields, String characteristicsClassName, String packageName) {
        CompilationUnit cloneCU = JavaParserUtils.getKiePMMLModelCompilationUnit((String)characteristicsClassName, (String)packageName, (String)KIE_PMML_CHARACTERISTICS_TEMPLATE_JAVA, (String)KIE_PMML_CHARACTERISTICS_TEMPLATE);
        ClassOrInterfaceDeclaration characteristicsTemplate = (ClassOrInterfaceDeclaration)cloneCU.getClassByName(characteristicsClassName).orElseThrow(() -> new KiePMMLException("Main class not found: KiePMMLCharacteristicsTemplate"));
        KiePMMLCharacteristicsFactory.setCharacteristicsVariableDeclaration(characteristicsClassName, characteristics, fields, characteristicsTemplate);
        HashMap<String, String> toReturn = new HashMap<String, String>();
        String fullClassName = packageName + "." + characteristicsClassName;
        toReturn.put(fullClassName, cloneCU.toString());
        return toReturn;
    }

    static void setCharacteristicsVariableDeclaration(String characteristicsClassName, Characteristics characteristics, List<Field<?>> fields, ClassOrInterfaceDeclaration characteristicsTemplate) {
        int counter = 0;
        NodeList arguments = new NodeList();
        for (Characteristic characteristic : characteristics.getCharacteristics()) {
            String characteristicVariableName = String.format("%s_%s", characteristicsClassName, counter);
            KiePMMLCharacteristicsFactory.addGetCharacteristicMethod(characteristicVariableName, characteristic, fields, characteristicsTemplate);
            MethodCallExpr toAdd = new MethodCallExpr();
            toAdd.setScope((Expression)new NameExpr(characteristicsClassName));
            toAdd.setName("get" + characteristicVariableName);
            arguments.add((Node)toAdd);
            ++counter;
        }
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)characteristicsTemplate.getDefaultConstructor().orElseThrow(() -> new KiePMMLInternalException(String.format("Missing default constructor in ClassOrInterfaceDeclaration %s ", characteristicsTemplate.getName())));
        constructorDeclaration.setName(characteristicsClassName);
        BlockStmt body = constructorDeclaration.getBody();
        ExplicitConstructorInvocationStmt superStatement = (ExplicitConstructorInvocationStmt)CommonCodegenUtils.getExplicitConstructorInvocationStmt((BlockStmt)body).orElseThrow(() -> new KiePMMLException(String.format("Missing constructor invocation in body %s", body)));
        superStatement.setArgument(0, (Expression)new StringLiteralExpr(characteristicsClassName));
        superStatement.setArgument(2, (Expression)CommonCodegenUtils.getArraysAsListInvocationMethodCall((NodeList)arguments));
    }

    static void addGetCharacteristicMethod(String characteristicVariableName, Characteristic characteristic, List<Field<?>> fields, ClassOrInterfaceDeclaration characteristicsTemplate) {
        BlockStmt toAdd = KiePMMLCharacteristicFactory.getCharacteristicVariableDeclaration(characteristicVariableName, characteristic, fields);
        toAdd.addStatement((Statement)new ReturnStmt(characteristicVariableName));
        MethodDeclaration methodDeclaration = characteristicsTemplate.addMethod("get" + characteristicVariableName, new Modifier.Keyword[0]).setBody(toAdd);
        methodDeclaration.setType(KiePMMLCharacteristic.class);
        methodDeclaration.setModifiers(new Modifier.Keyword[]{Modifier.Keyword.PRIVATE, Modifier.Keyword.STATIC});
    }
}

