/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.shaded.com.github.dockerjava.okhttp;

import com.github.dockerjava.transport.DockerHttpClient;
import java.io.IOException;
import java.io.InputStream;
import org.testcontainers.shaded.okhttp3.Interceptor;
import org.testcontainers.shaded.okhttp3.Request;
import org.testcontainers.shaded.okhttp3.Response;
import org.testcontainers.shaded.okhttp3.internal.connection.Exchange;
import org.testcontainers.shaded.okhttp3.internal.http.RealInterceptorChain;
import org.testcontainers.shaded.okhttp3.internal.ws.RealWebSocket;
import org.testcontainers.shaded.okio.BufferedSink;

class HijackingInterceptor
implements Interceptor {
    HijackingInterceptor() {
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        if (!response.isSuccessful()) {
            return response;
        }
        DockerHttpClient.Request originalRequest = request.tag(DockerHttpClient.Request.class);
        if (originalRequest == null) {
            return response;
        }
        InputStream stdin = originalRequest.hijackedInput();
        if (stdin == null) {
            return response;
        }
        chain.call().timeout().clearTimeout().clearDeadline();
        Exchange exchange = ((RealInterceptorChain)chain).exchange();
        RealWebSocket.Streams streams = exchange.newWebSocketStreams();
        Thread thread = new Thread(() -> {
            try (BufferedSink sink = streams.sink;){
                while (sink.isOpen()) {
                    int aByte = stdin.read();
                    if (aByte < 0) {
                        break;
                    }
                    sink.writeByte(aByte);
                    sink.emit();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        thread.setName("okhttp-hijack-streaming-" + System.identityHashCode(request));
        thread.setDaemon(true);
        thread.start();
        return response;
    }
}

