/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.lookup;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.optaplanner.core.impl.domain.lookup.LookUpStrategy;
import org.optaplanner.core.impl.domain.lookup.LookUpStrategyResolver;

public class LookUpManager {
    private final LookUpStrategyResolver lookUpStrategyResolver;
    private Map<Object, Object> idToWorkingObjectMap;

    public LookUpManager(LookUpStrategyResolver lookUpStrategyResolver) {
        this.lookUpStrategyResolver = lookUpStrategyResolver;
    }

    public void resetWorkingObjects(Collection<Object> allFacts) {
        this.idToWorkingObjectMap = new HashMap<Object, Object>(allFacts.size());
        for (Object fact : allFacts) {
            this.addWorkingObject(fact);
        }
    }

    public void addWorkingObject(Object workingObject) {
        LookUpStrategy lookUpStrategy = this.lookUpStrategyResolver.determineLookUpStrategy(workingObject);
        lookUpStrategy.addWorkingObject(this.idToWorkingObjectMap, workingObject);
    }

    public void removeWorkingObject(Object workingObject) {
        LookUpStrategy lookUpStrategy = this.lookUpStrategyResolver.determineLookUpStrategy(workingObject);
        lookUpStrategy.removeWorkingObject(this.idToWorkingObjectMap, workingObject);
    }

    public void clearWorkingObjects() {
        this.idToWorkingObjectMap = null;
    }

    public <E> E lookUpWorkingObject(E externalObject) {
        if (externalObject == null) {
            return null;
        }
        LookUpStrategy lookUpStrategy = this.lookUpStrategyResolver.determineLookUpStrategy(externalObject);
        return lookUpStrategy.lookUpWorkingObject(this.idToWorkingObjectMap, externalObject);
    }

    public <E> E lookUpWorkingObjectOrReturnNull(E externalObject) {
        if (externalObject == null) {
            return null;
        }
        LookUpStrategy lookUpStrategy = this.lookUpStrategyResolver.determineLookUpStrategy(externalObject);
        return lookUpStrategy.lookUpWorkingObjectIfExists(this.idToWorkingObjectMap, externalObject);
    }
}

