/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.ldap.deployment;

import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.elytron.security.deployment.ElytronPasswordMarkerBuildItem;
import io.quarkus.elytron.security.deployment.SecurityRealmBuildItem;
import io.quarkus.elytron.security.ldap.LdapRecorder;
import io.quarkus.elytron.security.ldap.config.LdapSecurityRealmRuntimeConfig;
import io.quarkus.elytron.security.ldap.deployment.config.LdapSecurityRealmBuildTimeConfig;
import io.quarkus.runtime.RuntimeValue;

class ElytronSecurityLdapProcessor {
    ElytronSecurityLdapProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.SECURITY_LDAP);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void configureLdapRealmAuthConfig(LdapRecorder recorder, LdapSecurityRealmBuildTimeConfig ldapSecurityRealmBuildTimeConfig, LdapSecurityRealmRuntimeConfig ldapSecurityRealmRuntimeConfig, BuildProducer<SecurityRealmBuildItem> securityRealm, BeanContainerBuildItem beanContainerBuildItem) throws Exception {
        if (!ldapSecurityRealmBuildTimeConfig.enabled) {
            return;
        }
        RuntimeValue realm = recorder.createRealm(ldapSecurityRealmRuntimeConfig);
        securityRealm.produce((BuildItem)new SecurityRealmBuildItem(realm, ldapSecurityRealmBuildTimeConfig.realmName, null));
    }

    @BuildStep
    ElytronPasswordMarkerBuildItem marker(LdapSecurityRealmBuildTimeConfig ldapSecurityRealmBuildTimeConfig) {
        if (!ldapSecurityRealmBuildTimeConfig.enabled) {
            return null;
        }
        return new ElytronPasswordMarkerBuildItem();
    }

    @BuildStep
    ReflectiveClassBuildItem enableReflection() {
        return new ReflectiveClassBuildItem(true, true, new String[]{"com.sun.jndi.ldap.LdapCtxFactory"});
    }
}

