/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.security;

import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.vertx.http.runtime.security.HttpSecurityPolicy;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import java.util.List;
import java.util.function.Function;

public class RolesAllowedHttpSecurityPolicy
implements HttpSecurityPolicy {
    private List<String> rolesAllowed;

    public RolesAllowedHttpSecurityPolicy(List<String> rolesAllowed) {
        this.rolesAllowed = rolesAllowed;
    }

    public RolesAllowedHttpSecurityPolicy() {
    }

    public List<String> getRolesAllowed() {
        return this.rolesAllowed;
    }

    public RolesAllowedHttpSecurityPolicy setRolesAllowed(List<String> rolesAllowed) {
        this.rolesAllowed = rolesAllowed;
        return this;
    }

    @Override
    public Uni<HttpSecurityPolicy.CheckResult> checkPermission(RoutingContext request, Uni<SecurityIdentity> identity, HttpSecurityPolicy.AuthorizationRequestContext requestContext) {
        return identity.map((Function)new Function<SecurityIdentity, HttpSecurityPolicy.CheckResult>(){

            @Override
            public HttpSecurityPolicy.CheckResult apply(SecurityIdentity securityIdentity) {
                for (String i : RolesAllowedHttpSecurityPolicy.this.rolesAllowed) {
                    if (!securityIdentity.hasRole(i)) continue;
                    return HttpSecurityPolicy.CheckResult.PERMIT;
                }
                return HttpSecurityPolicy.CheckResult.DENY;
            }
        });
    }
}

