/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.clustering.compiler.executor;

import java.util.Map;
import org.dmg.pmml.clustering.ClusteringModel;
import org.kie.pmml.api.enums.PMML_MODEL;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.compiler.api.dto.CompilationDTO;
import org.kie.pmml.compiler.api.provider.ModelImplementationProvider;
import org.kie.pmml.models.clustering.compiler.dto.ClusteringCompilationDTO;
import org.kie.pmml.models.clustering.compiler.factories.KiePMMLClusteringModelFactory;
import org.kie.pmml.models.clustering.model.KiePMMLClusteringModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringModelImplementationProvider
implements ModelImplementationProvider<ClusteringModel, KiePMMLClusteringModel> {
    private static final Logger logger = LoggerFactory.getLogger((String)ClusteringModelImplementationProvider.class.getName());

    public PMML_MODEL getPMMLModelType() {
        logger.trace("getPMMLModelType");
        return PMML_MODEL.CLUSTERING_MODEL;
    }

    public KiePMMLClusteringModel getKiePMMLModel(CompilationDTO<ClusteringModel> compilationDTO) {
        logger.trace("getKiePMMLModel {}", compilationDTO);
        return KiePMMLClusteringModelFactory.getKiePMMLClusteringModel(ClusteringCompilationDTO.fromCompilationDTO(compilationDTO));
    }

    public Map<String, String> getSourcesMap(CompilationDTO<ClusteringModel> compilationDTO) {
        logger.trace("getKiePMMLModelWithSources {}", compilationDTO);
        try {
            return KiePMMLClusteringModelFactory.getKiePMMLClusteringModelSourcesMap(ClusteringCompilationDTO.fromCompilationDTO(compilationDTO));
        }
        catch (Exception e) {
            throw new KiePMMLException((Throwable)e);
        }
    }

    public boolean isInterpreted() {
        return true;
    }
}

