/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.BytecodeCreatorImpl;
import io.quarkus.gizmo.WhileLoop;
import java.util.function.Function;
import org.objectweb.asm.MethodVisitor;

class WhileLoopImpl
extends BytecodeCreatorImpl
implements WhileLoop {
    private final BranchResult result;

    WhileLoopImpl(BytecodeCreatorImpl enclosing, Function<BytecodeCreator, BranchResult> conditionFun) {
        super(enclosing);
        BranchResult branchResult = conditionFun.apply(this);
        if (branchResult == null) {
            throw new IllegalArgumentException("BranchResult must not be null");
        }
        this.result = branchResult;
    }

    @Override
    protected void writeOperations(MethodVisitor visitor) {
        this.result.trueBranch().continueScope(this);
        this.result.falseBranch().breakScope(this);
        super.writeOperations(visitor);
    }

    @Override
    public BytecodeCreator block() {
        return this.result.trueBranch();
    }

    @Override
    public void doContinue(BytecodeCreator creator) {
        creator.continueScope(this);
    }

    @Override
    public void doBreak(BytecodeCreator creator) {
        creator.breakScope(this);
    }
}

