/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.quarkus.arc.runtime.ConfigRecorder;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ConfigDescriptionBuildItem;
import io.quarkus.dev.config.CurrentConfig;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ProfileManager;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescription;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescriptionsSupplier;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public class ConfigEditorProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public DevConsoleRuntimeTemplateInfoBuildItem config(ConfigRecorder recorder, List<ConfigDescriptionBuildItem> configDescriptionBuildItems) {
        ArrayList<ConfigDescription> configDescriptions = new ArrayList<ConfigDescription>();
        for (ConfigDescriptionBuildItem item : configDescriptionBuildItems) {
            configDescriptions.add(new ConfigDescription(item.getPropertyName(), item.getDocs(), item.getDefaultValue()));
        }
        return new DevConsoleRuntimeTemplateInfoBuildItem("config", (Supplier)new ConfigDescriptionsSupplier(configDescriptions));
    }

    @BuildStep
    DevConsoleRouteBuildItem handlePost() {
        CurrentConfig.EDITOR = ConfigEditorProcessor::updateConfig;
        return new DevConsoleRouteBuildItem("config", "POST", (Handler)new DevConsolePostHandler(){

            protected void handlePost(RoutingContext event, MultiMap form) throws Exception {
                String name = event.request().getFormAttribute("name");
                String value = event.request().getFormAttribute("value");
                Map<String, String> values = Collections.singletonMap(name, value);
                ConfigEditorProcessor.updateConfig(values);
                this.flashMessage(event, "Configuration updated");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void updateConfig(Map<String, String> values) {
        try {
            List resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
            if (resourcesDir.isEmpty()) {
                throw new IllegalStateException("Unable to manage configurations - no resource directory found");
            }
            Path path = (Path)resourcesDir.get(0);
            Path configPath = path.resolve("application.properties");
            if (!Files.exists(configPath, new LinkOption[0])) {
                configPath = Files.createFile(path.resolve("application.properties"), new FileAttribute[0]);
            }
            String profile = ProfileManager.getActiveProfile();
            List<String> lines = Files.readAllLines(configPath);
            for (Map.Entry<String, String> entry : values.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                name = !profile.equals(LaunchMode.DEVELOPMENT.getDefaultProfile()) ? "%" + profile + "." + name : name;
                int nameLine = -1;
                int linesSize = lines.size();
                for (int i = 0; i < linesSize; ++i) {
                    String line = lines.get(i);
                    if (!line.startsWith(name + "=")) continue;
                    nameLine = i;
                    break;
                }
                if (nameLine != -1) {
                    if (value.isEmpty()) {
                        lines.remove(nameLine);
                        continue;
                    }
                    lines.set(nameLine, name + "=" + value);
                    continue;
                }
                if (value.isEmpty()) continue;
                lines.add(name + "=" + value);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
                for (String i : lines) {
                    writer.write(i);
                    writer.newLine();
                }
            }
            DevConsoleManager.setDoingHttpInitiatedReload((boolean)true);
            try {
                DevConsoleManager.getHotReplacementContext().doScan(true);
            }
            finally {
                DevConsoleManager.setDoingHttpInitiatedReload((boolean)false);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

