/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;

public class KieServerConfig {
    public static final String UNKNOWN_STATUS = "UNKNOWN";
    public static final String SUCCESS_STATUS = "SUCCESS";
    private String id;
    private String name;
    private String host;
    @JsonIgnore
    private CredentialsProvider credentialsProvider;
    @JsonIgnore
    private KieServicesClient client;

    public String getId() {
        if (this.client == null) {
            return null;
        }
        try {
            if (this.id == null) {
                ServiceResponse info = this.client.getServerInfo();
                this.id = ((KieServerInfo)info.getResult()).getServerId();
            }
        }
        catch (Exception e) {
            return null;
        }
        return this.id;
    }

    public String getStatus() {
        if (this.client == null) {
            return UNKNOWN_STATUS;
        }
        try {
            return this.client.getServerInfo().getType().name();
        }
        catch (Exception e) {
            return UNKNOWN_STATUS;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KieServerConfig)) {
            return false;
        }
        KieServerConfig other = (KieServerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        CredentialsProvider this$credentialsProvider = this.getCredentialsProvider();
        CredentialsProvider other$credentialsProvider = other.getCredentialsProvider();
        if (this$credentialsProvider == null ? other$credentialsProvider != null : !this$credentialsProvider.equals(other$credentialsProvider)) {
            return false;
        }
        KieServicesClient this$client = this.getClient();
        KieServicesClient other$client = other.getClient();
        return !(this$client == null ? other$client != null : !this$client.equals(other$client));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KieServerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        CredentialsProvider $credentialsProvider = this.getCredentialsProvider();
        result = result * 59 + ($credentialsProvider == null ? 43 : $credentialsProvider.hashCode());
        KieServicesClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        return result;
    }

    public String toString() {
        return "KieServerConfig(id=" + this.getId() + ", name=" + this.getName() + ", host=" + this.getHost() + ", credentialsProvider=" + this.getCredentialsProvider() + ", client=" + this.getClient() + ")";
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public KieServicesClient getClient() {
        return this.client;
    }

    public KieServerConfig setId(String id) {
        this.id = id;
        return this;
    }

    public KieServerConfig setName(String name) {
        this.name = name;
        return this;
    }

    public KieServerConfig setHost(String host) {
        this.host = host;
        return this;
    }

    @JsonIgnore
    public KieServerConfig setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    @JsonIgnore
    public KieServerConfig setClient(KieServicesClient client) {
        this.client = client;
        return this;
    }
}

