/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.builder.item.SimpleBuildItem;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class TransformedClassesBuildItem
extends SimpleBuildItem {
    private final Map<Path, Set<TransformedClass>> transformedClassesByJar;
    private final Map<Path, Set<String>> transformedFilesByJar;

    public TransformedClassesBuildItem(Map<Path, Set<TransformedClass>> transformedClassesByJar) {
        this.transformedClassesByJar = new HashMap<Path, Set<TransformedClass>>(transformedClassesByJar);
        this.transformedFilesByJar = new HashMap<Path, Set<String>>();
        for (Map.Entry<Path, Set<TransformedClass>> e : transformedClassesByJar.entrySet()) {
            this.transformedFilesByJar.put(e.getKey(), e.getValue().stream().map(TransformedClass::getFileName).collect(Collectors.toSet()));
        }
    }

    public Map<Path, Set<TransformedClass>> getTransformedClassesByJar() {
        return this.transformedClassesByJar;
    }

    public Map<Path, Set<String>> getTransformedFilesByJar() {
        return this.transformedFilesByJar;
    }

    public static class TransformedClass {
        private final String className;
        private final byte[] data;
        private final String fileName;
        private final boolean eager;

        public TransformedClass(String className, byte[] data, String fileName, boolean eager) {
            this.className = className;
            this.data = data;
            this.fileName = fileName;
            this.eager = eager;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isEager() {
            return this.eager;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransformedClass that = (TransformedClass)o;
            return Objects.equals(this.fileName, that.fileName);
        }

        public int hashCode() {
            return Objects.hash(this.fileName);
        }
    }
}

