/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.model.AppModel;
import io.quarkus.bootstrap.model.CapabilityContract;
import io.quarkus.bootstrap.model.CapabilityErrors;
import io.quarkus.deployment.BooleanSupplierFactoryBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CapabilityBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import java.util.HashMap;
import java.util.List;
import java.util.function.BooleanSupplier;

public class CapabilityAggregationStep {
    @BuildStep
    void provideCapabilities(BuildProducer<CapabilityBuildItem> producer, CurateOutcomeBuildItem curateOutcomeBuildItem, BooleanSupplierFactoryBuildItem supplierFactory) {
        AppModel appModel = curateOutcomeBuildItem.getEffectiveModel();
        for (CapabilityContract contract : appModel.getCapabilityContracts().values()) {
            String provider = contract.getExtension();
            for (String capability : contract.getProvidesCapabilities()) {
                int conditionIndex = capability.indexOf(63);
                String name = conditionIndex < 0 ? capability : capability.substring(0, conditionIndex);
                boolean provide = true;
                while (conditionIndex > 0 && provide) {
                    Class<BooleanSupplier> testClass;
                    boolean inv = conditionIndex < capability.length() - 1 && capability.charAt(conditionIndex + 1) == '!';
                    int testClassStart = conditionIndex + (inv ? 2 : 1);
                    conditionIndex = capability.indexOf(63, testClassStart + 1);
                    String testClassName = capability.substring(testClassStart, conditionIndex > 0 ? conditionIndex : capability.length());
                    try {
                        testClass = Thread.currentThread().getContextClassLoader().loadClass(testClassName).asSubclass(BooleanSupplier.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Failed to load the condition class " + testClassName + " for capability " + name, e);
                    }
                    provide = supplierFactory.get(testClass).getAsBoolean();
                }
                if (!provide) continue;
                producer.produce(new CapabilityBuildItem(name, provider));
            }
        }
    }

    @BuildStep
    Capabilities aggregateCapabilities(List<CapabilityBuildItem> capabilities) {
        HashMap<String, String> providedCapabilities = new HashMap<String, String>();
        CapabilityErrors capabilityErrors = null;
        for (CapabilityBuildItem capabilityItem : capabilities) {
            String provider = capabilityItem.getProvider();
            String capability = capabilityItem.getName();
            String previous = providedCapabilities.put(capability, provider);
            if (previous == null) continue;
            if (previous instanceof String) {
                capabilityErrors = capabilityErrors == null ? (capabilityErrors = new CapabilityErrors()) : capabilityErrors;
                capabilityErrors.addConflict(capability, previous.toString());
                providedCapabilities.put(capability, (String)capabilityErrors);
            } else {
                capabilityErrors = (CapabilityErrors)previous;
            }
            capabilityErrors.addConflict(capability, provider);
            providedCapabilities.put(capability, (String)capabilityErrors);
        }
        if (capabilityErrors != null && !capabilityErrors.isEmpty()) {
            throw new IllegalStateException(capabilityErrors.report());
        }
        return new Capabilities(providedCapabilities.keySet());
    }
}

