/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.AutoInjectAnnotationBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

public class AutoAddScopeProcessor {
    private static final Logger LOGGER = Logger.getLogger(AutoAddScopeProcessor.class);

    @BuildStep
    void annotationTransformer(final List<AutoAddScopeBuildItem> autoScopes, final CustomScopeAnnotationsBuildItem scopes, List<AutoInjectAnnotationBuildItem> autoInjectAnnotations, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformers, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, final BeanArchiveIndexBuildItem beanArchiveIndex) throws Exception {
        if (autoScopes.isEmpty()) {
            return;
        }
        final Set containerAnnotationNames = autoInjectAnnotations.stream().flatMap(a -> a.getAnnotationNames().stream()).collect(Collectors.toSet());
        containerAnnotationNames.add(DotNames.POST_CONSTRUCT);
        containerAnnotationNames.add(DotNames.PRE_DESTROY);
        containerAnnotationNames.add(DotNames.INJECT);
        final HashSet unremovables = new HashSet();
        annotationsTransformers.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext context) {
                if (scopes.isScopeIn(context.getAnnotations())) {
                    return;
                }
                ClassInfo clazz = context.getTarget().asClass();
                Boolean requiresContainerServices = null;
                for (AutoAddScopeBuildItem autoScope : autoScopes) {
                    if (autoScope.isContainerServicesRequired()) {
                        if (requiresContainerServices == null) {
                            requiresContainerServices = AutoAddScopeProcessor.this.requiresContainerServices(clazz, containerAnnotationNames, beanArchiveIndex.getIndex());
                        }
                        if (!requiresContainerServices.booleanValue()) continue;
                    }
                    if (!autoScope.test(clazz, context.getAnnotations(), beanArchiveIndex.getIndex())) continue;
                    ((Transformation)context.transform().add(autoScope.getDefaultScope(), new AnnotationValue[0])).done();
                    if (autoScope.isUnremovable()) {
                        unremovables.add(clazz.name());
                    }
                    LOGGER.debugf("Automatically added scope %s to class %s" + autoScope.getReason(), (Object)autoScope.getDefaultScope(), (Object)clazz, (Object)autoScope.getReason());
                    break;
                }
            }
        }));
        if (!unremovables.isEmpty()) {
            unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(new Predicate<BeanInfo>(){

                @Override
                public boolean test(BeanInfo bean) {
                    return bean.isClassBean() && unremovables.contains(bean.getBeanClass());
                }
            }));
        }
    }

    private boolean requiresContainerServices(ClassInfo clazz, Set<DotName> containerAnnotationNames, IndexView index) {
        if (this.hasContainerAnnotation(clazz, containerAnnotationNames)) {
            return true;
        }
        if (index != null) {
            DotName superName = clazz.superName();
            while (superName != null && !superName.equals((Object)DotNames.OBJECT)) {
                ClassInfo superClass = index.getClassByName(superName);
                if (superClass != null) {
                    if (this.hasContainerAnnotation(superClass, containerAnnotationNames)) {
                        return true;
                    }
                    superName = superClass.superName();
                    continue;
                }
                superName = null;
            }
        }
        return false;
    }

    private boolean hasContainerAnnotation(ClassInfo clazz, Set<DotName> containerAnnotationNames) {
        if (clazz.annotations().isEmpty() || containerAnnotationNames.isEmpty()) {
            return false;
        }
        return this.containsAny(clazz, containerAnnotationNames);
    }

    private boolean containsAny(ClassInfo clazz, Set<DotName> annotationNames) {
        for (DotName annotation : clazz.annotations().keySet()) {
            if (!annotationNames.contains(annotation)) continue;
            return true;
        }
        return false;
    }
}

