/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.CredentialRetriever;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.registry.credentials.CredentialRetrievalException;
import java.util.Optional;

class RegistryCredentialRetriever {
    RegistryCredentialRetriever() {
    }

    static Optional<Credential> getBaseImageCredential(BuildContext buildContext) throws CredentialRetrievalException {
        return RegistryCredentialRetriever.retrieve(buildContext.getBaseImageConfiguration(), buildContext.getEventHandlers());
    }

    static Optional<Credential> getTargetImageCredential(BuildContext buildContext) throws CredentialRetrievalException {
        return RegistryCredentialRetriever.retrieve(buildContext.getTargetImageConfiguration(), buildContext.getEventHandlers());
    }

    private static Optional<Credential> retrieve(ImageConfiguration imageConfiguration, EventHandlers eventHandlers) throws CredentialRetrievalException {
        for (CredentialRetriever retriever : imageConfiguration.getCredentialRetrievers()) {
            Optional<Credential> credential = retriever.retrieve();
            if (!credential.isPresent()) continue;
            return credential;
        }
        String registry = imageConfiguration.getImageRegistry();
        String repository = imageConfiguration.getImageRepository();
        eventHandlers.dispatch(LogEvent.info("No credentials could be retrieved for " + registry + "/" + repository));
        return Optional.empty();
    }
}

