/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class Retry<E extends Exception> {
    private final Action<E> action;
    private int maximumRetries = 5;
    private Predicate<Exception> retryOnException = ignored -> true;
    private long sleepMilliseconds = -1L;

    public static <E extends Exception> Retry<E> action(Action<E> action) {
        return new Retry<E>(action);
    }

    private Retry(Action<E> action) {
        this.action = action;
    }

    public Retry<E> maximumRetries(int maximumRetries) {
        Preconditions.checkArgument((maximumRetries > 0 ? 1 : 0) != 0);
        this.maximumRetries = maximumRetries;
        return this;
    }

    public Retry<E> retryOnException(Predicate<Exception> retryOnException) {
        this.retryOnException = retryOnException;
        return this;
    }

    public Retry<E> sleep(long duration, TimeUnit unit) {
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0);
        this.sleepMilliseconds = unit.convert(duration, TimeUnit.MILLISECONDS);
        return this;
    }

    public boolean run() throws E {
        for (int i = 0; i < this.maximumRetries; ++i) {
            try {
                if (i > 0 && this.sleepMilliseconds >= 0L) {
                    Thread.sleep(this.sleepMilliseconds);
                }
                if (!this.action.run()) continue;
                return true;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (Exception ex) {
                if (i + 1 != this.maximumRetries && this.retryOnException.test(ex)) continue;
                throw ex;
            }
        }
        return false;
    }

    @FunctionalInterface
    public static interface Action<E extends Exception> {
        public boolean run() throws E;
    }
}

