/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.event.progress;

import com.google.cloud.tools.jib.event.events.ProgressEvent;
import com.google.cloud.tools.jib.event.progress.Allocation;
import com.google.cloud.tools.jib.event.progress.AllocationCompletionTracker;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.function.Consumer;

public class ProgressEventHandler
implements Consumer<ProgressEvent> {
    private final AllocationCompletionTracker completionTracker = new AllocationCompletionTracker();
    private final DoubleAdder progress = new DoubleAdder();
    private final Consumer<Update> updateNotifier;

    public ProgressEventHandler(Consumer<Update> updateNotifier) {
        this.updateNotifier = updateNotifier;
    }

    @Override
    public void accept(ProgressEvent progressEvent) {
        Allocation allocation = progressEvent.getAllocation();
        long progressUnits = progressEvent.getUnits();
        double allocationFraction = allocation.getFractionOfRoot();
        if (progressUnits != 0L) {
            this.progress.add((double)progressUnits * allocationFraction);
        }
        if (this.completionTracker.updateProgress(allocation, progressUnits)) {
            this.updateNotifier.accept(new Update(this.progress.sum(), this.completionTracker.getUnfinishedLeafTasks()));
        }
    }

    public static class Update {
        private final double progress;
        private final ImmutableList<String> unfinishedLeafTasks;

        private Update(double progress, ImmutableList<String> unfinishedLeafTasks) {
            this.progress = progress;
            this.unfinishedLeafTasks = unfinishedLeafTasks;
        }

        public double getProgress() {
            return this.progress;
        }

        public ImmutableList<String> getUnfinishedLeafTasks() {
            return this.unfinishedLeafTasks;
        }
    }
}

