/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.hash;

import com.google.cloud.tools.jib.api.DescriptorDigest;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CountingDigestOutputStream
extends DigestOutputStream {
    private static final String SHA_256_ALGORITHM = "SHA-256";
    private long bytesSoFar = 0L;

    public CountingDigestOutputStream(OutputStream outputStream) {
        super(outputStream, null);
        try {
            this.setMessageDigest(MessageDigest.getInstance(SHA_256_ALGORITHM));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("SHA-256 algorithm implementation not found - might be a broken JVM");
        }
    }

    public BlobDescriptor computeDigest() {
        try {
            byte[] hashedBytes = this.digest.digest();
            StringBuilder stringBuilder = new StringBuilder(2 * hashedBytes.length);
            for (byte b : hashedBytes) {
                stringBuilder.append(String.format("%02x", b));
            }
            String hash = stringBuilder.toString();
            BlobDescriptor blobDescriptor = new BlobDescriptor(this.bytesSoFar, DescriptorDigest.fromHash(hash));
            this.bytesSoFar = 0L;
            return blobDescriptor;
        }
        catch (DigestException ex) {
            throw new RuntimeException("SHA-256 algorithm produced invalid hash: " + ex.getMessage(), ex);
        }
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        super.write(data, offset, length);
        this.bytesSoFar += (long)length;
    }

    @Override
    public void write(int singleByte) throws IOException {
        super.write(singleByte);
        ++this.bytesSoFar;
    }
}

