/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.deployment;

import io.quarkus.security.deployment.SecurityAnnotationsRegistrar;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.security.DenyAll;
import javax.annotation.security.RolesAllowed;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;

public class SecurityTransformerUtils {
    public static final DotName DENY_ALL = DotName.createSimple((String)DenyAll.class.getName());
    public static final DotName ROLES_ALLOWED = DotName.createSimple((String)RolesAllowed.class.getName());
    private static final Set<DotName> SECURITY_ANNOTATIONS = SecurityAnnotationsRegistrar.SECURITY_BINDINGS.keySet();

    public static boolean hasStandardSecurityAnnotation(MethodInfo methodInfo) {
        return SecurityTransformerUtils.hasStandardSecurityAnnotation(methodInfo.annotations());
    }

    public static boolean hasStandardSecurityAnnotation(ClassInfo classInfo) {
        return SecurityTransformerUtils.hasStandardSecurityAnnotation(classInfo.classAnnotations());
    }

    private static boolean hasStandardSecurityAnnotation(Collection<AnnotationInstance> instances) {
        for (AnnotationInstance instance : instances) {
            if (!SECURITY_ANNOTATIONS.contains(instance.name())) continue;
            return true;
        }
        return false;
    }

    public static Optional<AnnotationInstance> findFirstStandardSecurityAnnotation(MethodInfo methodInfo) {
        return SecurityTransformerUtils.findFirstStandardSecurityAnnotation(methodInfo.annotations());
    }

    public static Optional<AnnotationInstance> findFirstStandardSecurityAnnotation(ClassInfo classInfo) {
        return SecurityTransformerUtils.findFirstStandardSecurityAnnotation(classInfo.classAnnotations());
    }

    private static Optional<AnnotationInstance> findFirstStandardSecurityAnnotation(Collection<AnnotationInstance> instances) {
        for (AnnotationInstance instance : instances) {
            if (!SECURITY_ANNOTATIONS.contains(instance.name())) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }
}

