/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.protocol;

import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Contract;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.EntityDetails;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpException;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpRequest;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.Method;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (Method.CONNECT.isSame(method)) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            if (request.containsHeader("Upgrade")) {
                request.addHeader("Connection", "upgrade");
            } else {
                request.addHeader("Connection", "keep-alive");
            }
        }
    }
}

