/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDefiningAnnotationBuildItem;
import io.quarkus.arc.deployment.CustomScopeAnnotationsBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.ShutdownListenerBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.configuration.ConfigurationError;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.deployment.util.WebJarUtil;
import io.quarkus.kubernetes.spi.KubernetesHealthLivenessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthReadinessPathBuildItem;
import io.quarkus.kubernetes.spi.KubernetesHealthStartupPathBuildItem;
import io.quarkus.runtime.shutdown.ShutdownListener;
import io.quarkus.smallrye.health.deployment.HealthBuildTimeConfig;
import io.quarkus.smallrye.health.deployment.HealthOpenAPIFilter;
import io.quarkus.smallrye.health.deployment.SmallRyeHealthBuildItem;
import io.quarkus.smallrye.health.deployment.SmallRyeHealthConfig;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import io.quarkus.smallrye.health.runtime.ShutdownReadinessListener;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthGroupHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthRecorder;
import io.quarkus.smallrye.health.runtime.SmallRyeHealthRuntimeConfig;
import io.quarkus.smallrye.health.runtime.SmallRyeIndividualHealthGroupHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeLivenessHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeReadinessHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeStartupHandler;
import io.quarkus.smallrye.health.runtime.SmallRyeWellnessHandler;
import io.quarkus.smallrye.openapi.deployment.spi.AddToOpenAPIDefinitionBuildItem;
import io.quarkus.vertx.http.deployment.NonApplicationRootPathBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.smallrye.health.SmallRyeHealthReporter;
import io.smallrye.health.api.HealthGroup;
import io.smallrye.health.api.HealthGroups;
import io.smallrye.health.api.Wellness;
import io.vertx.core.Handler;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.eclipse.microprofile.health.Startup;
import org.eclipse.microprofile.health.spi.HealthCheckResponseProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.logging.Logger;

class SmallRyeHealthProcessor {
    private static final Logger LOG = Logger.getLogger(SmallRyeHealthProcessor.class);
    private static final DotName LIVENESS = DotName.createSimple((String)Liveness.class.getName());
    private static final DotName READINESS = DotName.createSimple((String)Readiness.class.getName());
    private static final DotName STARTUP = DotName.createSimple((String)Startup.class.getName());
    private static final DotName HEALTH_GROUP = DotName.createSimple((String)HealthGroup.class.getName());
    private static final DotName HEALTH_GROUPS = DotName.createSimple((String)HealthGroups.class.getName());
    private static final DotName WELLNESS = DotName.createSimple((String)Wellness.class.getName());
    private static final DotName JAX_RS_PATH = DotName.createSimple((String)"javax.ws.rs.Path");
    private static final String HEALTH_UI_WEBJAR_GROUP_ID = "io.smallrye";
    private static final String HEALTH_UI_WEBJAR_ARTIFACT_ID = "smallrye-health-ui";
    private static final String HEALTH_UI_WEBJAR_PREFIX = "META-INF/resources/health-ui/";
    private static final String HEALTH_UI_FINAL_DESTINATION = "META-INF/health-ui-files";
    private static final String JS_FILE_TO_UPDATE = "healthui.js";
    private static final String INDEX_FILE_TO_UPDATE = "index.html";
    private static final String BRANDING_DIR = "META-INF/branding/";
    private static final String BRANDING_LOGO_GENERAL = "META-INF/branding/logo.png";
    private static final String BRANDING_LOGO_MODULE = "META-INF/branding/smallrye-health-ui.png";
    private static final String BRANDING_STYLE_GENERAL = "META-INF/branding/style.css";
    private static final String BRANDING_STYLE_MODULE = "META-INF/branding/smallrye-health-ui.css";
    private static final String BRANDING_FAVICON_GENERAL = "META-INF/branding/favicon.ico";
    private static final String BRANDING_FAVICON_MODULE = "META-INF/branding/smallrye-health-ui.ico";
    HealthBuildTimeConfig config;

    SmallRyeHealthProcessor() {
    }

    @BuildStep
    List<HotDeploymentWatchedFileBuildItem> brandingFiles() {
        return Stream.of(BRANDING_LOGO_GENERAL, BRANDING_STYLE_GENERAL, BRANDING_FAVICON_GENERAL, BRANDING_LOGO_MODULE, BRANDING_STYLE_MODULE, BRANDING_FAVICON_MODULE).map(HotDeploymentWatchedFileBuildItem::new).collect(Collectors.toList());
    }

    @BuildStep
    void healthCheck(BuildProducer<AdditionalBeanBuildItem> buildItemBuildProducer, List<HealthBuildItem> healthBuildItems) {
        boolean extensionsEnabled;
        boolean bl = extensionsEnabled = this.config.extensionsEnabled && ConfigProvider.getConfig().getOptionalValue("mp.health.disable-default-procedures", Boolean.TYPE).orElse(false) == false;
        if (extensionsEnabled) {
            for (HealthBuildItem buildItem : healthBuildItems) {
                if (!buildItem.isEnabled()) continue;
                buildItemBuildProducer.produce((BuildItem)new AdditionalBeanBuildItem(new String[]{buildItem.getHealthCheckClass()}));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    void build(SmallRyeHealthRecorder recorder, BuildProducer<FeatureBuildItem> feature, BuildProducer<AdditionalBeanBuildItem> additionalBean, BuildProducer<BeanDefiningAnnotationBuildItem> beanDefiningAnnotation) throws IOException, ClassNotFoundException {
        feature.produce((BuildItem)new FeatureBuildItem(Feature.SMALLRYE_HEALTH));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(LIVENESS));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(READINESS));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(STARTUP));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(HEALTH_GROUP));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(HEALTH_GROUPS));
        beanDefiningAnnotation.produce((BuildItem)new BeanDefiningAnnotationBuildItem(WELLNESS));
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SmallRyeHealthReporter.class}));
        additionalBean.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{HealthGroup.class}));
        Set providers = ServiceUtil.classNamesNamedIn((ClassLoader)this.getClass().getClassLoader(), (String)("META-INF/services/" + HealthCheckResponseProvider.class.getName()));
        if (providers.isEmpty()) {
            throw new IllegalStateException("No HealthCheckResponseProvider implementation found.");
        }
        if (providers.size() > 1) {
            throw new IllegalStateException(String.format("Multiple HealthCheckResponseProvider implementations found: %s", providers));
        }
        String provider = (String)providers.iterator().next();
        Class<?> responseProvider = Class.forName(provider, true, Thread.currentThread().getContextClassLoader());
        recorder.registerHealthCheckResponseProvider(responseProvider);
    }

    @BuildStep
    public void defineHealthRoutes(BuildProducer<RouteBuildItem> routes, BeanArchiveIndexBuildItem beanArchiveIndex, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, SmallRyeHealthConfig healthConfig) {
        IndexView index = beanArchiveIndex.getIndex();
        this.warnIfJaxRsPathUsed(index, LIVENESS);
        this.warnIfJaxRsPathUsed(index, READINESS);
        this.warnIfJaxRsPathUsed(index, STARTUP);
        this.warnIfJaxRsPathUsed(index, WELLNESS);
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(healthConfig.rootPath).routeConfigKey("quarkus.smallrye-health.root-path").handler((Handler)new SmallRyeHealthHandler()).displayOnNotFoundPage().blockingRoute().build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(healthConfig.rootPath, healthConfig.livenessPath).handler((Handler)new SmallRyeLivenessHandler()).displayOnNotFoundPage().blockingRoute().build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(healthConfig.rootPath, healthConfig.readinessPath).handler((Handler)new SmallRyeReadinessHandler()).displayOnNotFoundPage().blockingRoute().build());
        HashSet<String> healthGroups = new HashSet<String>();
        for (AnnotationInstance healthGroupAnnotation : index.getAnnotations(HEALTH_GROUP)) {
            healthGroups.add(healthGroupAnnotation.value().asString());
        }
        for (AnnotationInstance healthGroupsAnnotation : index.getAnnotations(HEALTH_GROUPS)) {
            for (AnnotationInstance healthGroupAnnotation : healthGroupsAnnotation.value().asNestedArray()) {
                healthGroups.add(healthGroupAnnotation.value().asString());
            }
        }
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(healthConfig.rootPath, healthConfig.groupPath).handler((Handler)new SmallRyeHealthGroupHandler()).displayOnNotFoundPage().blockingRoute().build());
        SmallRyeIndividualHealthGroupHandler handler = new SmallRyeIndividualHealthGroupHandler();
        for (String healthGroup : healthGroups) {
            routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(healthConfig.rootPath, healthConfig.groupPath + "/" + healthGroup).handler((Handler)handler).displayOnNotFoundPage().blockingRoute().build());
        }
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(healthConfig.rootPath, healthConfig.wellnessPath).handler((Handler)new SmallRyeWellnessHandler()).displayOnNotFoundPage().blockingRoute().build());
        routes.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().nestedRoute(healthConfig.rootPath, healthConfig.startupPath).handler((Handler)new SmallRyeStartupHandler()).displayOnNotFoundPage().blockingRoute().build());
    }

    @BuildStep
    public void translateSmallRyeConfigValues(SmallRyeHealthConfig healthConfig, BuildProducer<SystemPropertyBuildItem> systemProperties) {
        if (healthConfig.contextPropagation) {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("io.smallrye.health.context.propagation", "true"));
        }
    }

    @BuildStep(onlyIf={OpenAPIIncluded.class})
    public void includeInOpenAPIEndpoint(BuildProducer<AddToOpenAPIDefinitionBuildItem> openAPIProducer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, Capabilities capabilities, SmallRyeHealthConfig healthConfig) {
        if (capabilities.isPresent("io.quarkus.smallrye.openapi")) {
            String healthRootPath = nonApplicationRootPathBuildItem.resolvePath(healthConfig.rootPath);
            HealthOpenAPIFilter filter = new HealthOpenAPIFilter(healthRootPath, nonApplicationRootPathBuildItem.resolveNestedPath(healthRootPath, healthConfig.livenessPath), nonApplicationRootPathBuildItem.resolveNestedPath(healthRootPath, healthConfig.readinessPath), nonApplicationRootPathBuildItem.resolveNestedPath(healthRootPath, healthConfig.startupPath));
            openAPIProducer.produce((BuildItem)new AddToOpenAPIDefinitionBuildItem((OASFilter)filter));
        }
    }

    private void warnIfJaxRsPathUsed(IndexView index, DotName healthAnnotation) {
        Collection instances = index.getAnnotations(healthAnnotation);
        for (AnnotationInstance instance : instances) {
            boolean containsPath = false;
            AnnotationTarget target = instance.target();
            if (target.kind() == AnnotationTarget.Kind.CLASS) {
                if (target.asClass().classAnnotation(JAX_RS_PATH) != null) {
                    containsPath = true;
                }
            } else if (target.kind() == AnnotationTarget.Kind.METHOD && target.asMethod().hasAnnotation(JAX_RS_PATH)) {
                containsPath = true;
            }
            if (!containsPath) continue;
            LOG.warnv("The use of @Path has no effect when @{0} is used and should therefore be removed. Offending target is {1}: {2}", (Object)healthAnnotation.withoutPackagePrefix(), (Object)target.kind(), (Object)target);
        }
    }

    @BuildStep
    public void kubernetes(NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, SmallRyeHealthConfig healthConfig, BuildProducer<KubernetesHealthLivenessPathBuildItem> livenessPathItemProducer, BuildProducer<KubernetesHealthReadinessPathBuildItem> readinessPathItemProducer, BuildProducer<KubernetesHealthStartupPathBuildItem> startupPathItemProducer) {
        livenessPathItemProducer.produce((BuildItem)new KubernetesHealthLivenessPathBuildItem(nonApplicationRootPathBuildItem.resolveNestedPath(healthConfig.rootPath, healthConfig.livenessPath)));
        readinessPathItemProducer.produce((BuildItem)new KubernetesHealthReadinessPathBuildItem(nonApplicationRootPathBuildItem.resolveNestedPath(healthConfig.rootPath, healthConfig.readinessPath)));
        startupPathItemProducer.produce((BuildItem)new KubernetesHealthStartupPathBuildItem(nonApplicationRootPathBuildItem.resolveNestedPath(healthConfig.rootPath, healthConfig.startupPath)));
    }

    @BuildStep
    ShutdownListenerBuildItem shutdownListener() {
        return new ShutdownListenerBuildItem((ShutdownListener)new ShutdownReadinessListener());
    }

    @BuildStep
    AnnotationsTransformerBuildItem annotationTransformer(BeanArchiveIndexBuildItem beanArchiveIndex, final CustomScopeAnnotationsBuildItem scopes) {
        final HashSet<DotName> stereotypeAnnotations = new HashSet<DotName>();
        for (AnnotationInstance annotation : beanArchiveIndex.getIndex().getAnnotations(DotNames.STEREOTYPE)) {
            ClassInfo annotationClass = beanArchiveIndex.getIndex().getClassByName(annotation.name());
            if (annotationClass == null || !scopes.isScopeIn(annotationClass.classAnnotations())) continue;
            stereotypeAnnotations.add(annotationClass.name());
        }
        final ArrayList<DotName> healthAnnotations = new ArrayList<DotName>(5);
        healthAnnotations.add(LIVENESS);
        healthAnnotations.add(READINESS);
        healthAnnotations.add(STARTUP);
        healthAnnotations.add(HEALTH_GROUP);
        healthAnnotations.add(HEALTH_GROUPS);
        healthAnnotations.add(WELLNESS);
        return new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS || kind == AnnotationTarget.Kind.METHOD;
            }

            public void transform(AnnotationsTransformer.TransformationContext ctx) {
                Collection annotations;
                if (ctx.getAnnotations().isEmpty()) {
                    return;
                }
                if (ctx.isClass()) {
                    annotations = ctx.getAnnotations();
                    if (Annotations.containsAny((Collection)annotations, (Iterable)stereotypeAnnotations)) {
                        return;
                    }
                } else {
                    annotations = Annotations.getAnnotations((AnnotationTarget.Kind)AnnotationTarget.Kind.METHOD, (Collection)ctx.getAnnotations());
                }
                if (scopes.isScopeIn(annotations)) {
                    return;
                }
                if (Annotations.containsAny((Collection)annotations, (Iterable)healthAnnotations)) {
                    ((Transformation)ctx.transform().add(BuiltinScope.SINGLETON.getName(), new AnnotationValue[0])).done();
                }
            }
        });
    }

    @BuildStep
    void registerUiExtension(BuildProducer<GeneratedResourceBuildItem> generatedResourceProducer, BuildProducer<NativeImageResourceBuildItem> nativeImageResourceProducer, BuildProducer<SmallRyeHealthBuildItem> smallRyeHealthBuildProducer, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, SmallRyeHealthConfig healthConfig, CurateOutcomeBuildItem curateOutcomeBuildItem, LaunchModeBuildItem launchMode, LiveReloadBuildItem liveReloadBuildItem) throws Exception {
        if (SmallRyeHealthProcessor.shouldInclude(launchMode, healthConfig)) {
            if ("/".equals(healthConfig.ui.rootPath)) {
                throw new ConfigurationError("quarkus.smallrye-health.root-path-ui was set to \"/\", this is not allowed as it blocks the application from serving anything else.");
            }
            String healthPath = nonApplicationRootPathBuildItem.resolvePath(healthConfig.rootPath);
            String healthUiPath = nonApplicationRootPathBuildItem.resolvePath(healthConfig.ui.rootPath);
            AppArtifact artifact = WebJarUtil.getAppArtifact((CurateOutcomeBuildItem)curateOutcomeBuildItem, (String)HEALTH_UI_WEBJAR_GROUP_ID, (String)HEALTH_UI_WEBJAR_ARTIFACT_ID);
            if (launchMode.getLaunchMode().isDevOrTest()) {
                Path tempPath = WebJarUtil.copyResourcesForDevOrTest((LiveReloadBuildItem)liveReloadBuildItem, (CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)launchMode, (AppArtifact)artifact, (String)HEALTH_UI_WEBJAR_PREFIX);
                this.updateApiUrl(tempPath.resolve(JS_FILE_TO_UPDATE), healthPath);
                this.updateApiUrl(tempPath.resolve(INDEX_FILE_TO_UPDATE), healthPath);
                smallRyeHealthBuildProducer.produce((BuildItem)new SmallRyeHealthBuildItem(tempPath.toAbsolutePath().toString(), healthUiPath));
                if (liveReloadBuildItem.isLiveReload() && !liveReloadBuildItem.getChangedResources().isEmpty()) {
                    WebJarUtil.hotReloadBrandingChanges((CurateOutcomeBuildItem)curateOutcomeBuildItem, (LaunchModeBuildItem)launchMode, (AppArtifact)artifact, (Set)liveReloadBuildItem.getChangedResources());
                }
            } else {
                Map files = WebJarUtil.copyResourcesForProduction((CurateOutcomeBuildItem)curateOutcomeBuildItem, (AppArtifact)artifact, (String)HEALTH_UI_WEBJAR_PREFIX);
                for (Map.Entry file : files.entrySet()) {
                    Object fileName = (String)file.getKey();
                    byte[] content = (byte[])file.getValue();
                    if (((String)fileName).endsWith(JS_FILE_TO_UPDATE) || ((String)fileName).endsWith(INDEX_FILE_TO_UPDATE)) {
                        content = this.updateApiUrl(new String(content, StandardCharsets.UTF_8), healthPath).getBytes(StandardCharsets.UTF_8);
                    }
                    fileName = "META-INF/health-ui-files/" + (String)fileName;
                    generatedResourceProducer.produce((BuildItem)new GeneratedResourceBuildItem((String)fileName, content));
                    nativeImageResourceProducer.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{fileName}));
                }
                smallRyeHealthBuildProducer.produce((BuildItem)new SmallRyeHealthBuildItem(HEALTH_UI_FINAL_DESTINATION, healthUiPath));
            }
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void registerHealthUiHandler(BuildProducer<RouteBuildItem> routeProducer, SmallRyeHealthRecorder recorder, SmallRyeHealthRuntimeConfig runtimeConfig, SmallRyeHealthBuildItem smallRyeHealthBuildItem, NonApplicationRootPathBuildItem nonApplicationRootPathBuildItem, LaunchModeBuildItem launchMode, SmallRyeHealthConfig healthConfig) {
        if (SmallRyeHealthProcessor.shouldInclude(launchMode, healthConfig)) {
            Handler handler = recorder.uiHandler(smallRyeHealthBuildItem.getHealthUiFinalDestination(), smallRyeHealthBuildItem.getHealthUiPath(), runtimeConfig);
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(healthConfig.ui.rootPath).displayOnNotFoundPage("Health UI").routeConfigKey("quarkus.smallrye-health.ui.root-path").handler(handler).build());
            routeProducer.produce((BuildItem)nonApplicationRootPathBuildItem.routeBuilder().route(healthConfig.ui.rootPath + "*").handler(handler).build());
        }
    }

    private void updateApiUrl(Path fileToUpdate, String healthPath) throws IOException {
        String content = new String(Files.readAllBytes(fileToUpdate), StandardCharsets.UTF_8);
        String result = this.updateApiUrl(content, healthPath);
        if (result != null) {
            Files.write(fileToUpdate, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public String updateApiUrl(String original, String healthPath) {
        return original.replace("url = \"/health\";", "url = \"" + healthPath + "\";").replace("placeholder=\"/health\"", "placeholder=\"" + healthPath + "\"");
    }

    private static boolean shouldInclude(LaunchModeBuildItem launchMode, SmallRyeHealthConfig healthConfig) {
        return launchMode.getLaunchMode().isDevOrTest() || healthConfig.ui.alwaysInclude;
    }

    static class OpenAPIIncluded
    implements BooleanSupplier {
        HealthBuildTimeConfig config;

        OpenAPIIncluded() {
        }

        @Override
        public boolean getAsBoolean() {
            return this.config.openapiIncluded;
        }
    }
}

