/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.model.EndpointSpec;
import com.github.dockerjava.api.model.EndpointVirtualIP;
import com.github.dockerjava.api.model.PortConfig;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.CheckForNull;

public class Endpoint
implements Serializable {
    public static final long serialVersionUID = 1L;
    @JsonProperty(value="Spec")
    private EndpointSpec spec;
    @JsonProperty(value="Ports")
    private PortConfig[] ports;
    @JsonProperty(value="VirtualIPs")
    private EndpointVirtualIP[] virtualIPs;

    @CheckForNull
    public EndpointSpec getSpec() {
        return this.spec;
    }

    public Endpoint withSpec(EndpointSpec spec) {
        this.spec = spec;
        return this;
    }

    @CheckForNull
    public PortConfig[] getPorts() {
        return this.ports;
    }

    public Endpoint withPorts(PortConfig[] ports) {
        this.ports = ports;
        return this;
    }

    @CheckForNull
    public EndpointVirtualIP[] getVirtualIPs() {
        return this.virtualIPs;
    }

    public Endpoint withVirtualIPs(EndpointVirtualIP[] virtualIPs) {
        this.virtualIPs = virtualIPs;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EndpointSpec this$spec = this.getSpec();
        EndpointSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPorts(), other.getPorts())) {
            return false;
        }
        return Arrays.deepEquals(this.getVirtualIPs(), other.getVirtualIPs());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Endpoint;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EndpointSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getPorts());
        result = result * 59 + Arrays.deepHashCode(this.getVirtualIPs());
        return result;
    }

    public String toString() {
        return "Endpoint(spec=" + this.getSpec() + ", ports=" + Arrays.deepToString(this.getPorts()) + ", virtualIPs=" + Arrays.deepToString(this.getVirtualIPs()) + ")";
    }
}

