/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.blob;

import com.google.cloud.tools.jib.api.DescriptorDigest;

public class BlobDescriptor {
    private final DescriptorDigest digest;
    private final long size;

    public BlobDescriptor(long size, DescriptorDigest digest) {
        this.size = size;
        this.digest = digest;
    }

    public BlobDescriptor(DescriptorDigest digest) {
        this(-1L, digest);
    }

    public boolean hasSize() {
        return this.size >= 0L;
    }

    public DescriptorDigest getDigest() {
        return this.digest;
    }

    public long getSize() {
        return this.size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (this.size < 0L || !(obj instanceof BlobDescriptor)) {
            return false;
        }
        BlobDescriptor other = (BlobDescriptor)obj;
        return this.size == other.getSize() && this.digest.equals(other.getDigest());
    }

    public int hashCode() {
        int result = this.digest.hashCode();
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    public String toString() {
        return "digest: " + this.digest + ", size: " + this.size;
    }
}

