/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.rest;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.kie.processmigration.model.ProcessInfo;
import org.kie.processmigration.model.ProcessRef;
import org.kie.processmigration.model.RunningInstance;
import org.kie.processmigration.model.exceptions.InvalidKieServerException;
import org.kie.processmigration.model.exceptions.ProcessDefinitionNotFoundException;
import org.kie.processmigration.service.KieService;

@Path(value="/kieservers")
@Produces(value={"application/json"})
public class KieServiceResource {
    private static final String DEFAULT_PAGE = "0";
    private static final String DEFAULT_PAGE_SIZE = "100";
    private static final String DEFAULT_SORT_COLUMN = "processInstanceId";
    private static final String DEFAULT_SORT_ORDER = "asc";
    @Inject
    KieService kieService;

    @GET
    public Response getKieServers() {
        return Response.ok(this.kieService.getConfigs()).build();
    }

    @GET
    @Path(value="/{kieServerId}/definitions")
    public Response getDefinitions(@PathParam(value="kieServerId") String kieServerId) throws InvalidKieServerException {
        Map<String, Set<String>> definitions = this.kieService.getDefinitions(kieServerId);
        return Response.ok(definitions).build();
    }

    @GET
    @Path(value="/{kieServerId}/definitions/{containerId}/{processId}")
    public Response getDefinition(@PathParam(value="kieServerId") String kieServerId, @PathParam(value="containerId") String containerId, @PathParam(value="processId") String processId) throws InvalidKieServerException {
        try {
            ProcessInfo definition = this.kieService.getDefinition(kieServerId, new ProcessRef().setContainerId(containerId).setProcessId(processId));
            return Response.ok((Object)definition).build();
        }
        catch (ProcessDefinitionNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
    }

    @GET
    @Path(value="/{kieServerId}/instances/{containerId}")
    public Response getRunningInstances(@PathParam(value="kieServerId") String kieServerId, @PathParam(value="containerId") String containerId, @DefaultValue(value="0") @QueryParam(value="page") Integer page, @DefaultValue(value="100") @QueryParam(value="pageSize") Integer pageSize, @DefaultValue(value="processInstanceId") @QueryParam(value="sortBy") String sortBy, @DefaultValue(value="asc") @QueryParam(value="orderBy") String orderBy) throws InvalidKieServerException {
        List<RunningInstance> result = this.kieService.getRunningInstances(kieServerId, containerId, page, pageSize, sortBy, orderBy);
        Long total = this.kieService.countRunningInstances(kieServerId, containerId);
        return Response.ok(result).header("X-Total-Count", (Object)total).build();
    }
}

