/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.nl;

import java.io.PrintStream;
import java.security.AccessController;
import java.util.Vector;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.net.jdbc.nl.InvalidSyntaxException;

public final class NVPair {
    public static int RHS_NONE = 0;
    public static int RHS_ATOM = 1;
    public static int RHS_LIST = 2;
    public static int LIST_REGULAR = 3;
    public static int LIST_COMMASEP = 4;
    private String _name;
    private int _rhsType;
    private String _atom;
    private Vector _list;
    private int _listType;
    private NVPair _parent;
    static final String LINE_SEPARATOR = NVPair.getLineSeparatorProperty();

    public NVPair(String string) {
        this._name = string;
        this._atom = null;
        this._list = null;
        this._listType = LIST_REGULAR;
        this._parent = null;
        this._rhsType = RHS_NONE;
    }

    public NVPair(String string, String string2) throws InvalidSyntaxException {
        this(string);
        this.setAtom(string2);
    }

    public NVPair(String string, NVPair nVPair) {
        this(string);
        this.addListElement(nVPair);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public NVPair getParent() {
        return this._parent;
    }

    private void _setParent(NVPair nVPair) {
        this._parent = nVPair;
    }

    public int getRHSType() {
        return this._rhsType;
    }

    public int getListType() {
        return this._listType;
    }

    public void setListType(int n2) {
        this._listType = n2;
    }

    public String getAtom() {
        return this._atom;
    }

    public void setAtom(String string) throws InvalidSyntaxException {
        if (this._name.indexOf("COMMENT") == -1 && this.containsComment(string)) {
            Object[] objectArray = new Object[]{"#", this.getName()};
            throw new InvalidSyntaxException("UnexpectedChar-04603", objectArray);
        }
        this._rhsType = RHS_ATOM;
        this._atom = string;
        this._list = null;
    }

    private boolean containsComment(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) != '#') continue;
            if (i2 != 0) {
                if (string.charAt(i2 - 1) == '\\') continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public int getListSize() {
        if (this._list == null) {
            return 0;
        }
        return this._list.size();
    }

    public NVPair getListElement(int n2) {
        if (this._list == null) {
            return null;
        }
        return (NVPair)this._list.elementAt(n2);
    }

    public void addListElement(NVPair nVPair) {
        if (this._list == null) {
            this._rhsType = RHS_LIST;
            this._list = new Vector(3, 5);
            this._atom = null;
        }
        this._list.addElement(nVPair);
        nVPair._setParent(this);
    }

    public void removeListElement(int n2) {
        if (this._list != null) {
            this._list.removeElementAt(n2);
            if (this.getListSize() == 0) {
                this._list = null;
                this._rhsType = RHS_NONE;
            }
        }
    }

    private String space(int n2) {
        Object object = new String("");
        for (int i2 = 0; i2 < n2; ++i2) {
            object = (String)object + " ";
        }
        return object;
    }

    public String trimValueToString() {
        String string = this.valueToString().trim();
        return string.substring(1, string.length() - 1);
    }

    public String valueToString() {
        Object object;
        block3: {
            block4: {
                block2: {
                    object = "";
                    if (this._rhsType != RHS_ATOM) break block2;
                    object = (String)object + this._atom;
                    break block3;
                }
                if (this._rhsType != RHS_LIST) break block3;
                if (this._listType != LIST_REGULAR) break block4;
                for (int i2 = 0; i2 < this.getListSize(); ++i2) {
                    object = (String)object + this.getListElement(i2).toString();
                }
                break block3;
            }
            if (this._listType != LIST_COMMASEP) break block3;
            for (int i3 = 0; i3 < this.getListSize(); ++i3) {
                NVPair nVPair = this.getListElement(i3);
                object = (String)object + nVPair.getName();
                if (i3 == this.getListSize() - 1) continue;
                object = (String)object + ", ";
            }
        }
        return object;
    }

    @DisableTrace
    public String toString() {
        String string = "(" + this._name + "=";
        if (this._rhsType == RHS_ATOM) {
            string = string + this._atom;
        } else if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                for (int i2 = 0; i2 < this.getListSize(); ++i2) {
                    string = string + this.getListElement(i2).toString();
                }
            } else if (this._listType == LIST_COMMASEP) {
                string = string + " (";
                for (int i3 = 0; i3 < this.getListSize(); ++i3) {
                    NVPair nVPair = this.getListElement(i3);
                    string = string + nVPair.getName();
                    if (i3 == this.getListSize() - 1) continue;
                    string = string + ", ";
                }
                string = string + ")";
            }
        }
        string = string + ")";
        return string;
    }

    @DisableTrace
    public String toString(int n2, boolean bl) {
        Object object = "";
        String string = new String(this._name);
        if (this._rhsType == RHS_LIST) {
            if (this._listType == LIST_REGULAR) {
                Object object2 = "";
                for (int i2 = 0; i2 < this.getListSize(); ++i2) {
                    object2 = string.equalsIgnoreCase("ADDRESS") || string.equalsIgnoreCase("RULE") ? (String)object2 + this.getListElement(i2).toString(n2 + 1, false) : (String)object2 + this.getListElement(i2).toString(n2 + 1, true);
                }
                if (!((String)object2).equals("")) {
                    object = string.equalsIgnoreCase("ADDRESS") || string.equalsIgnoreCase("RULE") ? (String)object + this.space(n2 * 2) + "(" + this._name + " = " : (String)object + this.space(n2 * 2) + "(" + this._name + " =" + LINE_SEPARATOR;
                    object = (String)object + (String)object2;
                    object = string.equalsIgnoreCase("ADDRESS") || string.equalsIgnoreCase("RULE") ? (String)object + ")" + LINE_SEPARATOR : (n2 == 0 ? (String)object + ")" : (n2 == 1 ? (String)object + this.space(n2 * 2) + ")" : (String)object + this.space(n2 * 2) + ")" + LINE_SEPARATOR));
                }
            } else if (this._listType == LIST_COMMASEP) {
                object = (String)object + "(" + this._name + "= (";
                for (int i3 = 0; i3 < this.getListSize(); ++i3) {
                    NVPair nVPair = this.getListElement(i3);
                    object = (String)object + nVPair.getName();
                    if (i3 == this.getListSize() - 1) continue;
                    object = (String)object + ", ";
                }
                object = (String)object + "))";
            }
        } else if (this._rhsType == RHS_ATOM) {
            if (n2 == 0) {
                if (string.indexOf("COMMENT") != -1) {
                    this._atom = this.modifyCommentString(this._atom);
                    object = (String)object + "(" + this._atom + ")";
                } else {
                    object = (String)object + "(" + this._name + " = " + this._atom + ")";
                }
            } else if (string.indexOf("COMMENT") != -1) {
                this._atom = this.modifyCommentString(this._atom);
                object = (String)object + this._atom + LINE_SEPARATOR;
            } else if (!bl) {
                object = (String)object + "(" + this._name + " = " + this._atom + ")";
            } else {
                object = (String)object + this.space(n2 * 2) + "(" + this._name + " = " + this._atom + ")";
                object = (String)object + LINE_SEPARATOR;
            }
        }
        return object;
    }

    public String modifyCommentString(String string) {
        Object object = "";
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\\': {
                    if (string.charAt(i2 + 1) != '(' && string.charAt(i2 + 1) != '=' && string.charAt(i2 + 1) != ')' && string.charAt(i2 + 1) != ',' && string.charAt(i2 + 1) != '\\') break;
                }
            }
            int n2 = ++i2;
            object = (String)object + string.charAt(n2);
        }
        return object;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void println(PrintStream printStream) {
        if (this._rhsType == RHS_ATOM) {
            printStream.println("          (" + this._name + " = " + this._atom + ")");
        } else if (this._rhsType == RHS_LIST) {
            for (int i2 = 0; i2 < this.getListSize(); ++i2) {
                this.getListElement(i2).println(printStream);
            }
        }
    }

    private static String getLineSeparatorProperty() {
        return AccessController.doPrivileged(() -> System.getProperty("line.separator"));
    }
}

