/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven.dependency;

import io.quarkus.maven.dependency.AbstractDependencyBuilder;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.GACTV;
import java.io.Serializable;
import java.util.Objects;

public class ArtifactDependency
extends GACTV
implements Dependency,
Serializable {
    private final String scope;
    private int flags;

    @Deprecated(forRemoval=true)
    public static Dependency of(String groupId, String artifactId, String version) {
        return new ArtifactDependency(groupId, artifactId, null, "jar", version);
    }

    public ArtifactDependency(String groupId, String artifactId, String classifier, String type, String version) {
        super(groupId, artifactId, classifier, type, version);
        this.scope = "compile";
        this.flags = 0;
    }

    public ArtifactDependency(String groupId, String artifactId, String classifier, String type, String version, String scope, boolean optional) {
        super(groupId, artifactId, classifier, type, version);
        this.scope = scope;
        this.flags = optional ? 1 : 0;
    }

    public ArtifactDependency(ArtifactCoords coords, int ... flags) {
        this(coords, "compile", flags);
    }

    public ArtifactDependency(ArtifactCoords coords, String scope, int ... flags) {
        super(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion());
        this.scope = scope;
        int allFlags = 0;
        for (int f : flags) {
            allFlags |= f;
        }
        this.flags = allFlags;
    }

    public ArtifactDependency(Dependency d) {
        super(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType(), d.getVersion());
        this.scope = d.getScope();
        this.flags = d.getFlags();
    }

    public ArtifactDependency(AbstractDependencyBuilder<?, ?> builder) {
        super(builder.getGroupId(), builder.getArtifactId(), builder.getClassifier(), builder.getType(), builder.getVersion());
        this.scope = builder.getScope();
        this.flags = builder.getFlags();
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    public void setFlag(int flag) {
        this.flags |= flag;
    }

    public void clearFlag(int flag) {
        if ((this.flags & flag) > 0) {
            this.flags ^= flag;
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.flags, this.scope);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ArtifactDependency)) {
            return false;
        }
        ArtifactDependency other = (ArtifactDependency)obj;
        return this.flags == other.flags && Objects.equals(this.scope, other.scope);
    }

    @Override
    public String toString() {
        return "[" + this.toGACTVString() + " " + this.scope + " " + this.flags + "]";
    }
}

