/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicReference;

public class CompiledJavaVersionBuildStep {
    @BuildStep
    public CompiledJavaVersionBuildItem compiledJavaVersion(BuildSystemTargetBuildItem buildSystemTarget) {
        final AtomicReference<Object> majorVersion = new AtomicReference<Object>(null);
        try {
            Files.walkFileTree(buildSystemTarget.getOutputDirectory(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (!file.getFileName().toString().endsWith(".class")) return FileVisitResult.CONTINUE;
                    try (FileInputStream in = new FileInputStream(file.toFile());){
                        DataInputStream data = new DataInputStream(in);
                        if (-889275714 != data.readInt()) return FileVisitResult.CONTINUE;
                        data.readUnsignedShort();
                        majorVersion.set(data.readUnsignedShort());
                        FileVisitResult fileVisitResult = FileVisitResult.TERMINATE;
                        return fileVisitResult;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (majorVersion.get() == null) {
            return CompiledJavaVersionBuildItem.unknown();
        }
        return CompiledJavaVersionBuildItem.fromMajorJavaVersion((Integer)majorVersion.get());
    }
}

