/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.startup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.server.handlers.MediaTypeMapper;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

class RuntimeMappingDeployment {
    private final Map<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>> classTemplates;
    private final SortedMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>> nullMethod;
    private String currentHttpMethod;
    private List<RequestMapper.RequestPath<RuntimeResource>> currentMapperPerMethodTemplates;
    private Map<String, RequestMapper<RuntimeResource>> classMapper;
    private int maxMethodTemplateNameCount = -1;

    RuntimeMappingDeployment(Map<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>> classTemplates) {
        this.classTemplates = classTemplates;
        this.nullMethod = classTemplates.get(null);
    }

    int getMaxMethodTemplateNameCount() {
        if (this.maxMethodTemplateNameCount == -1) {
            throw new IllegalStateException("Method can only be called after 'buildClassMapper'");
        }
        return this.maxMethodTemplateNameCount;
    }

    Map<String, RequestMapper<RuntimeResource>> buildClassMapper() {
        this.classMapper = new HashMap<String, RequestMapper<RuntimeResource>>();
        this.maxMethodTemplateNameCount = 0;
        this.classTemplates.forEach(this::forEachClassTemplate);
        return this.classMapper;
    }

    private void forEachClassTemplate(String httpMethod, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>> perMethodTemplateMap) {
        this.currentHttpMethod = httpMethod;
        if (this.nullMethod != null) {
            for (Map.Entry<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>> nm : this.nullMethod.entrySet()) {
                if (perMethodTemplateMap.containsKey(nm.getKey())) continue;
                perMethodTemplateMap.put(nm.getKey(), nm.getValue());
            }
        }
        this.currentMapperPerMethodTemplates = new ArrayList<RequestMapper.RequestPath<RuntimeResource>>();
        perMethodTemplateMap.forEach(this::forEachMethodTemplateMap);
        this.classMapper.put(httpMethod, new RequestMapper(this.currentMapperPerMethodTemplates));
    }

    private void forEachMethodTemplateMap(URITemplate path, List<RequestMapper.RequestPath<RuntimeResource>> requestPaths) {
        int methodTemplateNameCount = path.countPathParamNames();
        if (methodTemplateNameCount > this.maxMethodTemplateNameCount) {
            this.maxMethodTemplateNameCount = methodTemplateNameCount;
        }
        if (requestPaths.size() == 1) {
            this.currentMapperPerMethodTemplates.addAll(requestPaths);
        } else {
            ArrayList<RuntimeResource> resources = new ArrayList<RuntimeResource>(requestPaths.size());
            for (int j = 0; j < requestPaths.size(); ++j) {
                resources.add((RuntimeResource)requestPaths.get((int)j).value);
            }
            MediaTypeMapper mapper = new MediaTypeMapper(resources);
            RuntimeResource fake = new RuntimeResource(this.currentHttpMethod, path, null, null, Collections.emptyList(), null, null, new ServerRestHandler[]{mapper}, null, new Class[0], null, false, null, null, null, null, null, Collections.emptyMap());
            this.currentMapperPerMethodTemplates.add(new RequestMapper.RequestPath<RuntimeResource>(false, fake.getPath(), fake));
        }
    }

    static void buildMethodMapper(Map<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>> perClassMappers, ResourceMethod method, RuntimeResource runtimeResource) {
        List<RequestMapper.RequestPath<RuntimeResource>> list;
        TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>> templateMap = perClassMappers.get(method.getHttpMethod());
        if (templateMap == null) {
            templateMap = new TreeMap();
            perClassMappers.put(method.getHttpMethod(), templateMap);
        }
        if ((list = templateMap.get(runtimeResource.getPath())) == null) {
            list = new ArrayList<RequestMapper.RequestPath<RuntimeResource>>();
            templateMap.put(runtimeResource.getPath(), list);
        }
        list.add(new RequestMapper.RequestPath<RuntimeResource>(method.getHttpMethod() == null, runtimeResource.getPath(), runtimeResource));
    }
}

