/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.io;

import aQute.lib.io.IO;
import aQute.libg.glob.PathSet;
import java.io.File;
import java.nio.file.Path;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class FileTree {
    private final List<File> files = new ArrayList<File>();
    private final PathSet paths = new PathSet();

    public void addFile(File file) {
        if (file == null) {
            return;
        }
        if (!this.files.contains(file)) {
            this.files.add(file);
        }
    }

    public void addIncludes(List<String> includes) {
        this.paths.includes(includes);
    }

    public void addIncludes(String ... includes) {
        this.paths.include(includes);
    }

    public void addExcludes(String ... excludes) {
        this.paths.exclude(excludes);
    }

    public void addExcludes(List<String> excludes) {
        this.paths.excludes(excludes);
    }

    public List<File> getFiles(File baseDir, String ... defaultIncludes) {
        return this.getFiles(baseDir, this.files.isEmpty() ? this.paths.matches(defaultIncludes) : this.paths.matches());
    }

    public List<File> getFiles(File baseDir, List<String> defaultIncludes) {
        return this.getFiles(baseDir, this.files.isEmpty() ? this.paths.matches(defaultIncludes) : this.paths.matches());
    }

    private List<File> getFiles(File baseDir, Predicate<String> matches) {
        ArrayList<File> result = new ArrayList<File>();
        new FileTreeSpliterator(baseDir, matches, this.files).forEachRemaining((Consumer<? super File>)((Consumer<File>)result::add));
        result.trimToSize();
        return result;
    }

    public Stream<File> stream(File baseDir, String ... defaultIncludes) {
        return this.stream(baseDir, this.files.isEmpty() ? this.paths.matches(defaultIncludes) : this.paths.matches());
    }

    public Stream<File> stream(File baseDir, List<String> defaultIncludes) {
        return this.stream(baseDir, this.files.isEmpty() ? this.paths.matches(defaultIncludes) : this.paths.matches());
    }

    private Stream<File> stream(File baseDir, Predicate<String> matches) {
        return StreamSupport.stream(new FileTreeSpliterator(baseDir, matches, this.files), false);
    }

    public String toString() {
        return String.format("[files: %s, paths: %s]", this.files, this.paths);
    }

    static final class FileTreeSpliterator
    extends Spliterators.AbstractSpliterator<File> {
        private final Path basePath;
        private final Predicate<String> matches;
        private final List<File> files;
        private final Spliterator<File> extra;
        private final Collator fileCollator = IO.fileCollator();
        private final Deque<File> queue = new ArrayDeque<File>();

        FileTreeSpliterator(File baseDir, Predicate<String> matches, List<File> files) {
            super(Long.MAX_VALUE, 1297);
            this.basePath = baseDir.toPath();
            this.matches = matches;
            ArrayList<File> copy = new ArrayList<File>(files);
            this.files = copy;
            this.extra = copy.spliterator();
            this.queueDirectoryContents(baseDir);
        }

        private void queueDirectoryContents(File dir) {
            String[] names;
            if (dir.isDirectory() && (names = dir.list()) != null) {
                int i;
                int length = names.length;
                Object[] keys = new CollationKey[length];
                for (i = 0; i < length; ++i) {
                    keys[i] = this.fileCollator.getCollationKey(names[i]);
                }
                Arrays.sort(keys);
                for (i = length - 1; i >= 0; --i) {
                    this.queue.addFirst(new File(dir, ((CollationKey)keys[i]).getSourceString()));
                }
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super File> action) {
            File next;
            while ((next = this.queue.pollFirst()) != null) {
                this.queueDirectoryContents(next);
                Path path = this.basePath.relativize(next.toPath());
                if (!this.matches.test(path.toString())) continue;
                this.files.remove(next);
                action.accept(next);
            }
            this.extra.forEachRemaining(action);
        }

        @Override
        public boolean tryAdvance(Consumer<? super File> action) {
            File next;
            while ((next = this.queue.pollFirst()) != null) {
                this.queueDirectoryContents(next);
                Path path = this.basePath.relativize(next.toPath());
                if (!this.matches.test(path.toString())) continue;
                this.files.remove(next);
                action.accept(next);
                return true;
            }
            return this.extra.tryAdvance(action);
        }
    }
}

