/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.api.DockerClient;
import com.google.cloud.tools.jib.api.DockerDaemonImage;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.JibEvent;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.TarImage;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.StepsRunner;
import com.google.cloud.tools.jib.configuration.BuildContext;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.docker.CliDockerClient;
import com.google.cloud.tools.jib.docker.DockerClientResolver;
import com.google.cloud.tools.jib.event.EventHandlers;
import com.google.cloud.tools.jib.filesystem.XdgDirectories;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Containerizer {
    public static final Path DEFAULT_BASE_CACHE_DIRECTORY = XdgDirectories.getCacheHome();
    public static final String DEFAULT_APPLICATION_CACHE_DIRECTORY_NAME = "jib-core-application-layers-cache";
    private static final String DEFAULT_TOOL_NAME = "jib-core";
    private static final String DEFAULT_TOOL_VERSION = Containerizer.class.getPackage().getImplementationVersion();
    private static final String DESCRIPTION_FOR_DOCKER_REGISTRY = "Building and pushing image";
    private static final String DESCRIPTION_FOR_DOCKER_DAEMON = "Building image to Docker daemon";
    private static final String DESCRIPTION_FOR_TARBALL = "Building image tarball";
    private final String description;
    private final ImageConfiguration imageConfiguration;
    private final Function<BuildContext, StepsRunner> stepsRunnerFactory;
    private final boolean mustBeOnline;
    private final Set<String> additionalTags = new HashSet<String>();
    private final EventHandlers.Builder eventHandlersBuilder = EventHandlers.builder();
    @Nullable
    private ExecutorService executorService;
    private Path baseImageLayersCacheDirectory = DEFAULT_BASE_CACHE_DIRECTORY;
    @Nullable
    private Path applicationLayersCacheDirectory;
    private boolean allowInsecureRegistries = false;
    private boolean offline = false;
    private String toolName = "jib-core";
    @Nullable
    private String toolVersion = DEFAULT_TOOL_VERSION;
    private boolean alwaysCacheBaseImage = false;
    private ListMultimap<String, String> registryMirrors = ArrayListMultimap.create();

    public static Containerizer to(RegistryImage registryImage) {
        ImageConfiguration imageConfiguration = ImageConfiguration.builder(registryImage.getImageReference()).setCredentialRetrievers(registryImage.getCredentialRetrievers()).build();
        Function<BuildContext, StepsRunner> stepsRunnerFactory = buildContext -> StepsRunner.begin(buildContext).registryPushSteps();
        return new Containerizer(DESCRIPTION_FOR_DOCKER_REGISTRY, imageConfiguration, stepsRunnerFactory, true);
    }

    public static Containerizer to(DockerDaemonImage dockerDaemonImage) {
        DockerClient dockerClient = DockerClientResolver.resolve(dockerDaemonImage.getDockerEnvironment()).orElse(new CliDockerClient(dockerDaemonImage.getDockerExecutable(), dockerDaemonImage.getDockerEnvironment()));
        return Containerizer.to(dockerClient, dockerDaemonImage);
    }

    public static Containerizer to(TarImage tarImage) {
        Optional<ImageReference> imageReference = tarImage.getImageReference();
        if (!imageReference.isPresent()) {
            throw new IllegalArgumentException("Image name must be set when building a TarImage; use TarImage#named(...) to set the name of the target image");
        }
        ImageConfiguration imageConfiguration = ImageConfiguration.builder(imageReference.get()).build();
        Function<BuildContext, StepsRunner> stepsRunnerFactory = buildContext -> StepsRunner.begin(buildContext).tarBuildSteps(tarImage.getPath());
        return new Containerizer(DESCRIPTION_FOR_TARBALL, imageConfiguration, stepsRunnerFactory, false);
    }

    public static Containerizer to(DockerClient dockerClient, DockerDaemonImage dockerDaemonImage) {
        ImageConfiguration imageConfiguration = ImageConfiguration.builder(dockerDaemonImage.getImageReference()).build();
        Function<BuildContext, StepsRunner> stepsRunnerFactory = buildContext -> StepsRunner.begin(buildContext).dockerLoadSteps(dockerClient);
        return new Containerizer(DESCRIPTION_FOR_DOCKER_DAEMON, imageConfiguration, stepsRunnerFactory, false);
    }

    private Containerizer(String description, ImageConfiguration imageConfiguration, Function<BuildContext, StepsRunner> stepsRunnerFactory, boolean mustBeOnline) {
        this.description = description;
        this.imageConfiguration = imageConfiguration;
        this.stepsRunnerFactory = stepsRunnerFactory;
        this.mustBeOnline = mustBeOnline;
    }

    public Containerizer withAdditionalTag(String tag) {
        Preconditions.checkArgument((boolean)ImageReference.isValidTag(tag), (String)"invalid tag '%s'", (Object)tag);
        this.additionalTags.add(tag);
        return this;
    }

    public Containerizer setExecutorService(@Nullable ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Containerizer setBaseImageLayersCache(Path cacheDirectory) {
        this.baseImageLayersCacheDirectory = cacheDirectory;
        return this;
    }

    public Containerizer setApplicationLayersCache(Path cacheDirectory) {
        this.applicationLayersCacheDirectory = cacheDirectory;
        return this;
    }

    public <E extends JibEvent> Containerizer addEventHandler(Class<E> eventType, Consumer<? super E> eventConsumer) {
        this.eventHandlersBuilder.add(eventType, eventConsumer);
        return this;
    }

    public Containerizer addEventHandler(Consumer<JibEvent> eventConsumer) {
        this.eventHandlersBuilder.add(JibEvent.class, eventConsumer);
        return this;
    }

    public Containerizer setAllowInsecureRegistries(boolean allowInsecureRegistries) {
        this.allowInsecureRegistries = allowInsecureRegistries;
        return this;
    }

    public Containerizer setOfflineMode(boolean offline) {
        if (this.mustBeOnline && offline) {
            throw new IllegalStateException("Cannot build to a container registry in offline mode");
        }
        this.offline = offline;
        return this;
    }

    public Containerizer setToolName(String toolName) {
        this.toolName = toolName;
        return this;
    }

    public Containerizer setToolVersion(@Nullable String toolVersion) {
        this.toolVersion = toolVersion;
        return this;
    }

    public Containerizer setAlwaysCacheBaseImage(boolean alwaysCacheBaseImage) {
        this.alwaysCacheBaseImage = alwaysCacheBaseImage;
        return this;
    }

    public Containerizer addRegistryMirrors(String registry, List<String> mirrors) {
        this.registryMirrors.putAll((Object)registry, mirrors);
        return this;
    }

    Set<String> getAdditionalTags() {
        return ImmutableSet.copyOf(this.additionalTags);
    }

    ListMultimap<String, String> getRegistryMirrors() {
        return ImmutableListMultimap.copyOf(this.registryMirrors);
    }

    Optional<ExecutorService> getExecutorService() {
        return Optional.ofNullable(this.executorService);
    }

    Path getBaseImageLayersCacheDirectory() {
        return this.baseImageLayersCacheDirectory;
    }

    Path getApplicationLayersCacheDirectory() throws CacheDirectoryCreationException {
        if (this.applicationLayersCacheDirectory == null) {
            try {
                Path tmp = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
                this.applicationLayersCacheDirectory = tmp.resolve(DEFAULT_APPLICATION_CACHE_DIRECTORY_NAME);
                Files.createDirectories(this.applicationLayersCacheDirectory, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new CacheDirectoryCreationException(ex);
            }
        }
        return this.applicationLayersCacheDirectory;
    }

    EventHandlers buildEventHandlers() {
        return this.eventHandlersBuilder.build();
    }

    boolean getAllowInsecureRegistries() {
        return this.allowInsecureRegistries;
    }

    boolean isOfflineMode() {
        return this.offline;
    }

    String getToolName() {
        return this.toolName;
    }

    @Nullable
    String getToolVersion() {
        return this.toolVersion;
    }

    boolean getAlwaysCacheBaseImage() {
        return this.alwaysCacheBaseImage;
    }

    String getDescription() {
        return this.description;
    }

    ImageConfiguration getImageConfiguration() {
        return this.imageConfiguration;
    }

    BuildResult run(BuildContext buildContext) throws ExecutionException, InterruptedException {
        return this.stepsRunnerFactory.apply(buildContext).run();
    }
}

