/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jackson.runtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.quarkus.arc.All;
import io.quarkus.arc.DefaultBean;
import io.quarkus.jackson.ObjectMapperCustomizer;
import io.quarkus.jackson.runtime.JacksonBuildTimeConfig;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;

@ApplicationScoped
public class ObjectMapperProducer {
    @DefaultBean
    @Singleton
    @Produces
    public ObjectMapper objectMapper(@All List<ObjectMapperCustomizer> customizers, JacksonBuildTimeConfig jacksonBuildTimeConfig) {
        ZoneId zoneId;
        JsonInclude.Include serializationInclusion;
        ObjectMapper objectMapper = new ObjectMapper();
        if (!jacksonBuildTimeConfig.failOnUnknownProperties) {
            objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
        if (!jacksonBuildTimeConfig.failOnEmptyBeans) {
            objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        }
        if (!jacksonBuildTimeConfig.writeDatesAsTimestamps) {
            objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
        if (!jacksonBuildTimeConfig.writeDurationsAsTimestamps) {
            objectMapper.disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
        }
        if (jacksonBuildTimeConfig.acceptCaseInsensitiveEnums) {
            objectMapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        }
        if ((serializationInclusion = (JsonInclude.Include)jacksonBuildTimeConfig.serializationInclusion.orElse(null)) != null) {
            objectMapper.setSerializationInclusion(serializationInclusion);
        }
        if ((zoneId = (ZoneId)jacksonBuildTimeConfig.timezone.orElse(null)) != null && !zoneId.getId().equals("UTC")) {
            objectMapper.setTimeZone(TimeZone.getTimeZone(zoneId));
        }
        List<ObjectMapperCustomizer> sortedCustomizers = this.sortCustomizersInDescendingPriorityOrder(customizers);
        for (ObjectMapperCustomizer customizer : sortedCustomizers) {
            customizer.customize(objectMapper);
        }
        return objectMapper;
    }

    private List<ObjectMapperCustomizer> sortCustomizersInDescendingPriorityOrder(Iterable<ObjectMapperCustomizer> customizers) {
        ArrayList<ObjectMapperCustomizer> sortedCustomizers = new ArrayList<ObjectMapperCustomizer>();
        for (ObjectMapperCustomizer customizer : customizers) {
            sortedCustomizers.add(customizer);
        }
        Collections.sort(sortedCustomizers);
        return sortedCustomizers;
    }
}

