/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CBfileAccessor;
import oracle.jdbc.driver.T4CBinaryDoubleAccessor;
import oracle.jdbc.driver.T4CBinaryFloatAccessor;
import oracle.jdbc.driver.T4CBlobAccessor;
import oracle.jdbc.driver.T4CCharAccessor;
import oracle.jdbc.driver.T4CClobAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CDateAccessor;
import oracle.jdbc.driver.T4CIntervaldsAccessor;
import oracle.jdbc.driver.T4CIntervalymAccessor;
import oracle.jdbc.driver.T4CJsonAccessor;
import oracle.jdbc.driver.T4CLongAccessor;
import oracle.jdbc.driver.T4CLongRawAccessor;
import oracle.jdbc.driver.T4CNamedTypeAccessor;
import oracle.jdbc.driver.T4CNumberAccessor;
import oracle.jdbc.driver.T4COutRawAccessor;
import oracle.jdbc.driver.T4CPlsqlBooleanAccessor;
import oracle.jdbc.driver.T4CPlsqlIndexTableAccessor;
import oracle.jdbc.driver.T4CRawAccessor;
import oracle.jdbc.driver.T4CRefTypeAccessor;
import oracle.jdbc.driver.T4CResultSetAccessor;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.driver.T4CRowidBinder;
import oracle.jdbc.driver.T4CRowidNullBinder;
import oracle.jdbc.driver.T4CTimestampAccessor;
import oracle.jdbc.driver.T4CTimestampltzAccessor;
import oracle.jdbc.driver.T4CTimestamptzAccessor;
import oracle.jdbc.driver.T4CURowidBinder;
import oracle.jdbc.driver.T4CURowidNullBinder;
import oracle.jdbc.driver.T4CVarcharAccessor;
import oracle.jdbc.driver.T4CVarnumAccessor;
import oracle.jdbc.driver.VarcharNullBinder;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleTypeDATE;
import oracle.jdbc.oracore.OracleTypeTIMESTAMP;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CCallableStatement
extends OracleCallableStatement {
    static final byte[] EMPTY_BYTE = new byte[0];
    T4CConnection t4Connection;
    private long beyondRowData = 0L;
    final String[] nlsStrings = new String[]{"AUTH_NLS_LXLAN", "AUTH_NLS_LXCTERRITORY", "AUTH_NLS_LXCCURRENCY", "AUTH_NLS_LXCISOCURR", "AUTH_NLS_LXCNUMERICS", "AUTH_NLS_LXCDATEFM", "AUTH_NLS_LXCDATELANG", "AUTH_NLS_LXCSORT", "AUTH_NLS_LXCCALENDAR", "AUTH_NLS_LXCUNIONCUR", "AUTH_NLS_LXCTIMEFM", "AUTH_NLS_LXCSTMPFM", "AUTH_NLS_LXCTTZNFM", "AUTH_NLS_LXCSTZNFM", "SESSION_TIME_ZONE", "AL8KW_ENABLED_ROLES", "AL8KW_ERR_OVLAP", "AL8KW_EDITION", "AL8KW_AUX_SESSSTATE"};

    T4CCallableStatement(PhysicalConnection physicalConnection, String string, @Blind(value=PropertiesBlinder.class) Properties properties) throws SQLException {
        super(physicalConnection, string, properties);
        this.t4Connection = (T4CConnection)physicalConnection;
        this.nbPostPonedColumns = new int[1];
        this.nbPostPonedColumns[0] = 0;
        this.indexOfPostPonedColumn = new int[1][3];
    }

    @Override
    protected Binder createRowidBinder(byte[] byArray) throws SQLException {
        return new T4CRowidBinder(byArray);
    }

    @Override
    protected Binder createURowidBinder(byte[] byArray) throws SQLException {
        return new T4CURowidBinder(byArray);
    }

    @Override
    protected Binder createRowidNullBinder() throws SQLException {
        return new T4CRowidNullBinder();
    }

    @Override
    protected Binder createURowidNullBinder() throws SQLException {
        return new T4CURowidNullBinder();
    }

    private final int getFirstRowInBatchForOALL8() {
        return this.batchFIFOFront == null ? 0 : this.firstRowInBatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOall8(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2) throws SQLException, IOException {
        int n3 = this.prepareForOALL8(bl, bl2, bl3, bl4, n2);
        if (n3 == -1) {
            return;
        }
        boolean bl6 = bl5 && bl4 && this.isRowidPrepended;
        T4C8Oall t4C8Oall = this.initializeOALL8(bl6, n3);
        try {
            t4C8Oall.doOALL(bl, bl2, bl3, bl4, bl5);
        }
        catch (SQLException sQLException) {
            if (!this.handleOALL8Failure(sQLException)) {
                throw sQLException;
            }
        }
        finally {
            this.handleOALL8CompletionAlways(t4C8Oall);
        }
    }

    final void doOall8Async(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, Consumer<Throwable> consumer) {
        T4C8Oall t4C8Oall;
        try {
            int n3 = this.prepareForOALL8(bl, bl2, bl3, bl4, n2);
            if (n3 == -1) {
                consumer.accept(null);
                return;
            }
            boolean bl6 = bl5 && bl4 && this.isRowidPrepended;
            t4C8Oall = this.initializeOALL8(bl6, n3);
        }
        catch (SQLException sQLException) {
            consumer.accept(sQLException);
            return;
        }
        t4C8Oall.doOALLAsync(bl, bl2, bl3, bl4, bl5, throwable -> {
            try {
                if (throwable instanceof SQLException && this.handleOALL8Failure((SQLException)throwable)) {
                    throwable = null;
                }
            }
            catch (Throwable throwable2) {
                throwable = CompletionStageUtil.suppress(throwable2, throwable);
            }
            try {
                this.handleOALL8CompletionAlways(t4C8Oall);
            }
            catch (Throwable throwable3) {
                throwable = CompletionStageUtil.suppress(throwable3, throwable);
            }
            consumer.accept((Throwable)throwable);
        });
    }

    private final int prepareForOALL8(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2) throws SQLException {
        if (bl || bl4 || !bl2) {
            this.oacdefSent = null;
        }
        if (bl2) {
            this.beyondRowData = this.bindUseDBA ? this.beyondBindData : 0L;
        }
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.doOall8");
        if (this.sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
            this.sqlKind = OracleStatement.SqlKind.OTHER;
        }
        int n3 = this.rowPrefetch;
        if (bl3) {
            this.rowPrefetchInLastFetch = n3 = this.getMaximumRowFetchForOALL8();
            if (n3 == 0 && this.isAllFetched) {
                return -1;
            }
            this.rowData.setPosition(this.beyondRowData);
        }
        this.prepareAccessorRowCountsForOALL8(n2);
        this.prepareBindsByteArrayForOALL8();
        this.allocateTmpByteArray();
        return n3;
    }

    private final int getMaximumRowFetchForOALL8() {
        boolean bl;
        long l2 = this.indexOfFirstRow + (long)this.storedRowCount;
        boolean bl2 = bl = this.maxRows > 0L && this.maxRows <= l2 + (long)this.rowPrefetch;
        if (bl) {
            this.isAllFetched = true;
            return (int)(this.maxRows - l2);
        }
        return this.rowPrefetch;
    }

    private final void prepareAccessorRowCountsForOALL8(int n2) {
        int n3;
        if (this.accessors != null) {
            for (n3 = 0; n3 < this.accessors.length; ++n3) {
                if (this.accessors[n3] == null) continue;
                this.accessors[n3].lastRowProcessed = n2;
            }
        }
        if (this.outBindAccessors != null) {
            for (n3 = 0; n3 < this.outBindAccessors.length; ++n3) {
                if (this.outBindAccessors[n3] == null) continue;
                this.outBindAccessors[n3].lastRowProcessed = 0;
            }
        }
    }

    private final void prepareBindsByteArrayForOALL8() {
        if (this.bindIndicators != null) {
            int n2 = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            int n3 = 0;
            if (this.ibtBindChars != null) {
                n3 = this.ibtBindChars.length * this.connection.conversion.cMaxCharSize;
            }
            for (int i2 = 0; i2 < this.numberOfBindPositions; ++i2) {
                int n4 = this.bindIndicatorSubRange + 5 + 10 * i2;
                int n5 = this.bindIndicators[n4 + 2] & 0xFFFF;
                if (n5 == 0) continue;
                int n6 = this.bindIndicators[n4 + 9] & 0xFFFF;
                if (this.bindUseDBA) continue;
                n3 = n6 == 2 ? Math.max(n5 * this.connection.conversion.maxNCharSize, n3) : Math.max(n5 * this.connection.conversion.cMaxCharSize, n3);
            }
            if (this.tmpBindsByteArray == null) {
                this.tmpBindsByteArray = new byte[n3];
            } else if (this.tmpBindsByteArray.length < n3) {
                this.tmpBindsByteArray = null;
                this.tmpBindsByteArray = new byte[n3];
            }
        } else {
            this.tmpBindsByteArray = null;
        }
    }

    private final T4C8Oall initializeOALL8(boolean bl, int n2) throws SQLException {
        T4C8Oall t4C8Oall = this.t4Connection.all8;
        t4C8Oall.typeOfStatement = this.sqlKind;
        t4C8Oall.cursor = this.cursorId;
        t4C8Oall.sqlStmt = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
        t4C8Oall.rowsToFetch = n2;
        t4C8Oall.outBindAccessors = this.outBindAccessors;
        t4C8Oall.numberOfBindPositions = this.numberOfBindPositions;
        t4C8Oall.definesAccessors = this.accessors;
        t4C8Oall.definesLength = this.getNumberOfDefinePositionsForOALL8();
        t4C8Oall.bindBytes = this.bindBytes;
        t4C8Oall.bindChars = this.bindChars;
        t4C8Oall.bindIndicators = this.bindIndicators;
        t4C8Oall.bindIndicatorSubRange = this.bindIndicatorSubRange;
        t4C8Oall.conversion = this.connection.conversion;
        t4C8Oall.tmpBindsByteArray = this.tmpBindsByteArray;
        t4C8Oall.parameterStream = this.parameterStream;
        t4C8Oall.oracleStatement = this;
        t4C8Oall.ibtBindBytes = this.ibtBindBytes;
        t4C8Oall.ibtBindChars = this.ibtBindChars;
        t4C8Oall.ibtBindIndicators = this.ibtBindIndicators;
        t4C8Oall.oacdefBindsSent = this.oacdefSent;
        t4C8Oall.definedColumnType = this.getDefinedColumnTypesForOALL8(bl);
        t4C8Oall.definedColumnSize = this.getDefinedColumnSizesForOALL8(bl);
        t4C8Oall.definedColumnFormOfUse = this.getDefinedColumnFormsOfUseForOALL8(bl);
        t4C8Oall.registration = this.registration;
        t4C8Oall.bindData = this.bindData;
        t4C8Oall.bindDataOffsets = this.bindDataOffsets;
        t4C8Oall.bindDataLengths = this.bindDataLengths;
        t4C8Oall.bindUseDBA = this.bindUseDBA;
        return t4C8Oall;
    }

    private final int getNumberOfDefinePositionsForOALL8() {
        if (this.sqlKind.isDML()) {
            return 0;
        }
        return this.numberOfDefinePositions;
    }

    private final int[] getDefinedColumnTypesForOALL8(boolean bl) {
        if (bl) {
            int[] nArray = new int[this.definedColumnType.length + 1];
            System.arraycopy(this.definedColumnType, 0, nArray, 1, this.definedColumnType.length);
            nArray[0] = -8;
            return nArray;
        }
        return this.definedColumnType;
    }

    private final int[] getDefinedColumnSizesForOALL8(boolean bl) {
        if (bl) {
            int[] nArray = new int[this.definedColumnSize.length + 1];
            System.arraycopy(this.definedColumnSize, 0, nArray, 1, this.definedColumnSize.length);
            return nArray;
        }
        return this.definedColumnSize;
    }

    private final int[] getDefinedColumnFormsOfUseForOALL8(boolean bl) {
        if (bl) {
            int[] nArray = new int[this.definedColumnFormOfUse.length + 1];
            System.arraycopy(this.definedColumnFormOfUse, 0, nArray, 1, this.definedColumnFormOfUse.length);
            return nArray;
        }
        return this.definedColumnFormOfUse;
    }

    private boolean handleOALL8Failure(SQLException sQLException) {
        if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
            this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            return true;
        }
        return false;
    }

    private final void handleOALL8CompletionAlways(T4C8Oall t4C8Oall) throws SQLException {
        int n2 = t4C8Oall.getCursorId();
        if (n2 != 0) {
            this.setCursorId(n2);
        }
        this.oacdefSent = t4C8Oall.oacdefBindsSent;
        if (this.connection.isPDBChanged) {
            this.connection.onPDBChange(this);
            this.connection.isPDBChanged = false;
        }
        this.beyondRowData = Math.max(this.beyondRowData, this.rowData.getPosition());
    }

    @Override
    void allocateTmpByteArray() {
        block1: {
            block0: {
                if (this.tmpByteArray != null) break block0;
                this.tmpByteArray = new byte[this.sizeTmpByteArray];
                break block1;
            }
            if (this.sizeTmpByteArray <= this.tmpByteArray.length) break block1;
            this.tmpByteArray = new byte[this.sizeTmpByteArray];
        }
    }

    @Override
    void releaseBuffers() {
        super.releaseBuffers();
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        if (this.t4Connection != null) {
            this.t4Connection.all8.bindChars = null;
            this.t4Connection.all8.bindBytes = null;
            this.t4Connection.all8.tmpBindsByteArray = null;
        }
    }

    @Override
    void allocateRowidAccessor() throws SQLException {
        this.accessors[0] = new T4CRowidAccessor(this, 128, 1, -8, false, this.t4Connection.mare);
    }

    @Override
    void reparseOnRedefineIfNeeded() throws SQLException {
        this.needToParse = true;
    }

    @Override
    protected void defineColumnTypeInternal(int n2, int n3, int n4, short s2, boolean bl, String string) throws SQLException {
        int[] nArray;
        if (this.connection.disableDefinecolumntype) {
            return;
        }
        if (n3 == -15 || n3 == -9 || n3 == -16) {
            s2 = (short)2;
        }
        if (n2 < 1) {
            throw (SQLException)DatabaseError.createSqlException(3).fillInStackTrace();
        }
        if (this.currentResultSet != null && !this.currentResultSet.closed) {
            throw (SQLException)DatabaseError.createSqlException(28).fillInStackTrace();
        }
        int n5 = n2 - 1;
        if (this.definedColumnType == null || this.definedColumnType.length <= n5) {
            if (this.definedColumnType == null) {
                this.definedColumnType = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnType, 0, nArray, 0, this.definedColumnType.length);
                this.definedColumnType = nArray;
            }
        }
        this.definedColumnType[n5] = n3;
        if (this.definedColumnSize == null || this.definedColumnSize.length <= n5) {
            if (this.definedColumnSize == null) {
                this.definedColumnSize = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnSize, 0, nArray, 0, this.definedColumnSize.length);
                this.definedColumnSize = nArray;
            }
        }
        int n6 = this.definedColumnSize[n5] = n3 == 2005 || n3 == 2004 || n3 == 2016 ? n4 : -1;
        if (this.definedColumnFormOfUse == null || this.definedColumnFormOfUse.length <= n5) {
            if (this.definedColumnFormOfUse == null) {
                this.definedColumnFormOfUse = new int[(n5 + 1) * 4];
            } else {
                nArray = new int[(n5 + 1) * 4];
                System.arraycopy(this.definedColumnFormOfUse, 0, nArray, 0, this.definedColumnFormOfUse.length);
                this.definedColumnFormOfUse = nArray;
            }
        }
        this.definedColumnFormOfUse[n5] = s2;
        this.executeDoneForDefines = false;
    }

    @Override
    public void clearDefines() throws SQLException {
        try (Monitor.CloseableLock closeableLock = this.connection.acquireCloseableLock();){
            super.clearDefines();
            this.definedColumnType = null;
            this.definedColumnSize = null;
            this.definedColumnFormOfUse = null;
            if (this.t4Connection != null && this.t4Connection.all8 != null) {
                this.t4Connection.all8.definesAccessors = null;
            }
        }
    }

    @Override
    void doSetSnapshotSCN(long l2) throws SQLException {
        this.inScn = l2;
    }

    @Override
    protected void configureRowData() {
        this.bindData = this.rowData = DynamicByteArray.createDynamicByteArray(this.connection.getBlockSource());
        this.bindUseDBA = this.connection.bindUseDBA;
    }

    @Override
    protected final void locationToPutBytes(Accessor accessor, int n2, int n3) throws SQLException {
        accessor.setOffset(n2, this.allocateRowDataSpace(n3));
    }

    @Override
    long allocateRowDataSpace(int n2) {
        long l2 = this.beyondRowData;
        this.beyondRowData += (long)n2;
        return l2;
    }

    @Override
    Accessor allocateAccessor(int n2, int n3, int n4, int n5, short s2, String string, boolean bl) throws SQLException {
        Accessor accessor = null;
        switch (n2) {
            case 96: {
                accessor = new T4CCharAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 8: {
                if (!bl) {
                    accessor = new T4CLongAccessor(this, n4, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
            }
            case 1: {
                accessor = new T4CVarcharAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 2: {
                accessor = new T4CNumberAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 6: {
                accessor = new T4CVarnumAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 252: {
                accessor = new T4CPlsqlBooleanAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 24: {
                if (!bl) {
                    accessor = new T4CLongRawAccessor(this, n4, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
            }
            case 23: {
                if (bl && string != null) {
                    throw (SQLException)DatabaseError.createSqlException(12, "sqlType=" + n3).fillInStackTrace();
                }
                if (bl) {
                    accessor = new T4COutRawAccessor(this, n5, s2, n3, this.t4Connection.mare);
                    break;
                }
                accessor = new T4CRawAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 100: {
                accessor = new T4CBinaryFloatAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 101: {
                accessor = new T4CBinaryDoubleAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 104: 
            case 208: {
                if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK || this.sqlObject.returningIntoParameterCount > 0) {
                    accessor = new T4CVarcharAccessor(this, 18, s2, n3, bl, this.t4Connection.mare);
                    accessor.definedColumnType = -8;
                    break;
                }
                accessor = new T4CRowidAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 102: {
                accessor = new T4CResultSetAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 12: {
                accessor = new T4CDateAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 113: {
                accessor = new T4CBlobAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 119: {
                accessor = new T4CJsonAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 112: {
                accessor = new T4CClobAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 114: {
                accessor = new T4CBfileAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 109: {
                accessor = new T4CNamedTypeAccessor(this, string, s2, n3, bl, this.t4Connection.mare);
                accessor.initMetadata();
                break;
            }
            case 111: {
                accessor = new T4CRefTypeAccessor(this, string, s2, n3, bl, this.t4Connection.mare);
                accessor.initMetadata();
                break;
            }
            case 180: {
                accessor = new T4CTimestampAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 181: {
                accessor = new T4CTimestamptzAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 231: {
                accessor = new T4CTimestampltzAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 182: {
                accessor = new T4CIntervalymAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 183: {
                accessor = new T4CIntervaldsAccessor(this, n5, s2, n3, bl, this.t4Connection.mare);
                break;
            }
            case 995: {
                throw (SQLException)DatabaseError.createSqlException(89).fillInStackTrace();
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 41, (Object)(n4 + 1)).fillInStackTrace();
            }
        }
        return accessor;
    }

    @Override
    void doDescribe(boolean bl) throws SQLException {
        if (!this.isOpen) {
            this.connection.open(this);
            this.isOpen = true;
        }
        byte[] byArray = this.sqlObject.getSqlBytes(this.processEscapes, this.convertNcharLiterals);
        try {
            this.t4Connection.needLine();
            this.t4Connection.describe.doODNY(this, 0, this.accessors, byArray);
            this.accessors = this.t4Connection.describe.getAccessors();
            this.numberOfDefinePositions = this.t4Connection.describe.numuds;
            for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
                this.accessors[i2].initMetadata();
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
        this.describedWithNames = true;
        this.described = true;
    }

    @Override
    void executeForDescribe() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.execute_for_describe");
        try {
            this.doOall8(true, true, this.definedColumnType != null, true, this.definedColumnType != null, this.getFirstRowInBatchForOALL8());
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
        finally {
            this.updateAfterDescribeAlways();
        }
        this.updateAfterDescribeWithoutError();
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            this.accessors[i2].initMetadata();
        }
        this.needToPrepareDefineBuffer = false;
    }

    @Override
    final void executeForDescribeAsync(Consumer<Throwable> consumer) {
        try {
            this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CPreparedStatement.execute_for_describe");
        }
        catch (SQLException sQLException) {
            consumer.accept(sQLException);
        }
        this.doOall8Async(true, true, this.definedColumnType != null, true, this.definedColumnType != null, this.getFirstRowInBatchForOALL8(), throwable2 -> {
            try {
                if (throwable2 instanceof IOException) {
                    IOException iOException = (IOException)throwable2;
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    throwable2 = DatabaseError.createSqlException(iOException).fillInStackTrace();
                }
            }
            catch (Throwable throwable3) {
                throwable2 = CompletionStageUtil.suppress(throwable3, throwable2);
            }
            try {
                this.updateAfterDescribeAlways();
                if (throwable2 == null) {
                    this.updateAfterDescribeWithoutError();
                }
            }
            catch (Throwable throwable4) {
                throwable2 = CompletionStageUtil.suppress(throwable4, throwable2);
            }
            if (throwable2 == null) {
                CompletionStageUtil.callOnComplete(this.initAccessorMetadataAsync(), (void_, throwable) -> {
                    this.needToPrepareDefineBuffer = false;
                    consumer.accept((Throwable)throwable);
                });
            } else {
                consumer.accept((Throwable)throwable2);
            }
        });
    }

    private CompletionStage<Void> initAccessorMetadataAsync() {
        CompletionStage<Void> completionStage = CompletionStageUtil.VOID_COMPLETED_FUTURE;
        for (int i2 = 0; i2 < this.numberOfDefinePositions; ++i2) {
            if (completionStage.toCompletableFuture().isDone()) {
                completionStage = this.accessors[i2].initMetadataAsync();
                continue;
            }
            Accessor accessor = this.accessors[i2];
            completionStage = completionStage.thenCompose(void_ -> accessor.initMetadataAsync());
        }
        if (completionStage.toCompletableFuture().isDone()) {
            this.needToPrepareDefineBuffer = false;
            return CompletionStageUtil.VOID_COMPLETED_FUTURE;
        }
        return completionStage.thenRun(() -> {
            this.needToPrepareDefineBuffer = false;
        });
    }

    private final void updateAfterDescribeAlways() throws SQLException {
        this.rowsProcessed = this.t4Connection.all8.rowsProcessed;
        this.validRows = this.t4Connection.all8.getNumRows();
        if (this.connection.checksumMode.needToCalculateFetchChecksum()) {
            if (this.validRows > 0L) {
                this.calculateCheckSum();
            } else if (this.rowsProcessed > 0L) {
                long l2;
                this.checkSum = l2 = CRC64.updateChecksum(this.checkSum, this.rowsProcessed);
            }
        }
    }

    private final void updateAfterDescribeWithoutError() throws SQLException {
        this.needToParse = false;
        if (this.definedColumnType == null) {
            this.implicitDefineForLobPrefetchDone = false;
        }
        this.aFetchWasDoneDuringDescribe = false;
        if (this.t4Connection.all8.aFetchWasDone) {
            this.aFetchWasDoneDuringDescribe = true;
            this.rowPrefetchInLastFetch = this.rowPrefetch;
        }
    }

    @Override
    void executeForRows(boolean bl) throws SQLException {
        try {
            try {
                boolean bl2 = this.prepareForExecuteForRows();
                this.doOall8(this.needToParse, !bl, true, false, bl2, this.getFirstRowInBatchForOALL8());
                this.handleExecuteForRowsCompletion(bl2);
            }
            finally {
                this.handleExecuteForRowsCompletionAlways();
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    @Override
    void executeForRowsAsync(boolean bl, Consumer<Throwable> consumer) {
        boolean bl2;
        try {
            bl2 = this.prepareForExecuteForRows();
        }
        catch (SQLException sQLException) {
            consumer.accept(sQLException);
            return;
        }
        this.doOall8Async(this.needToParse, !bl, true, false, bl2, this.getFirstRowInBatchForOALL8(), throwable -> {
            try {
                if (throwable == null) {
                    this.handleExecuteForRowsCompletion(bl2);
                }
            }
            catch (Throwable throwable2) {
                throwable = CompletionStageUtil.suppress(throwable2, throwable);
            }
            try {
                this.handleExecuteForRowsCompletionAlways();
            }
            catch (Throwable throwable3) {
                throwable = CompletionStageUtil.suppress(throwable3, throwable);
            }
            try {
                if (throwable instanceof IOException) {
                    IOException iOException = (IOException)throwable;
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    throwable = DatabaseError.createSqlException(iOException).fillInStackTrace();
                }
            }
            catch (Throwable throwable4) {
                throwable = CompletionStageUtil.suppress(throwable4, throwable);
            }
            consumer.accept((Throwable)throwable);
        });
    }

    private final boolean prepareForExecuteForRows() throws SQLException {
        if (this.columnsDefinedByUser) {
            this.needToPrepareDefineBuffer = false;
            return false;
        }
        return this.prepareLobDefinesForExecution();
    }

    private final void handleExecuteForRowsCompletionAlways() throws SQLException {
        this.validRows = this.implicitResultSetStatements == null ? this.t4Connection.all8.getNumRows() : 0L;
        this.calculateCheckSum();
    }

    private final void handleExecuteForRowsCompletion(boolean bl) {
        this.needToParse = false;
        if (bl) {
            this.implicitDefineForLobPrefetchDone = true;
        }
    }

    private final boolean prepareLobDefinesForExecution() throws SQLException {
        if (!this.t4Connection.useLobPrefetch || this.accessors == null || this.defaultLobPrefetchSize == -1 || this.implicitDefineForLobPrefetchDone || this.aFetchWasDoneDuringDescribe || this.definedColumnType != null) {
            return false;
        }
        boolean bl = false;
        int[] nArray = new int[this.accessors.length];
        int[] nArray2 = new int[this.accessors.length];
        int[] nArray3 = new int[this.accessors.length];
        for (int i2 = 0; i2 < this.accessors.length; ++i2) {
            if (this.accessors[i2] == null) continue;
            nArray[i2] = this.getJDBCType(this.accessors[i2].internalType);
            nArray3[i2] = this.accessors[i2].formOfUse;
            if (this.accessors[i2].internalType == 113 || this.accessors[i2].internalType == 112 || this.accessors[i2].internalType == 114) {
                bl = true;
                this.accessors[i2].setPrefetchLength(this.defaultLobPrefetchSize);
                nArray2[i2] = this.defaultLobPrefetchSize;
                continue;
            }
            if (this.accessors[i2].internalType != 119) continue;
            bl = true;
            this.accessors[i2].setPrefetchLength(0x2000000);
            nArray2[i2] = 0x2000000;
        }
        if (bl) {
            this.definedColumnType = nArray;
            this.definedColumnSize = nArray2;
            this.definedColumnFormOfUse = nArray3;
            return true;
        }
        return false;
    }

    @Override
    protected void fetch(int n2, boolean bl) throws SQLException {
        if (!bl) {
            this.setRowDataPositionBeforeFetch();
        }
        this.releaseStreamsBeforeFetch();
        boolean bl2 = this.prepareLobDefinesForExecution();
        try {
            this.doOall8(false, false, true, false, bl2, n2);
            this.handleFetchCompletion(bl2, n2);
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
    }

    @Override
    protected final void fetchAsync(int n2, boolean bl, Consumer<Throwable> consumer) {
        boolean bl2;
        if (!bl) {
            this.setRowDataPositionBeforeFetch();
        }
        try {
            this.releaseStreamsBeforeFetch();
            bl2 = this.prepareLobDefinesForExecution();
        }
        catch (SQLException sQLException) {
            consumer.accept(sQLException);
            return;
        }
        this.doOall8Async(false, false, true, false, bl2, n2, throwable -> {
            try {
                if (throwable == null) {
                    this.handleFetchCompletion(bl2, n2);
                }
            }
            catch (Throwable throwable2) {
                throwable = CompletionStageUtil.suppress(throwable2, throwable);
            }
            try {
                if (throwable instanceof IOException) {
                    IOException iOException = (IOException)throwable;
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    throwable = (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
                }
            }
            catch (Throwable throwable3) {
                throwable = CompletionStageUtil.suppress(throwable3, throwable);
            }
            consumer.accept((Throwable)throwable);
        });
    }

    @Override
    final boolean isFetchAsyncSupported() {
        return true;
    }

    private final void setRowDataPositionBeforeFetch() {
        if (this.rowData != null) {
            this.beyondRowData = this.bindUseDBA ? this.beyondBindData : 0L;
        }
    }

    private final void releaseStreamsBeforeFetch() throws SQLException {
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
    }

    private final void handleFetchCompletion(boolean bl, int n2) throws SQLException {
        if (bl) {
            this.implicitDefineForLobPrefetchDone = true;
        }
        this.validRows = this.t4Connection.all8.getNumRows();
        if (this.validRows != -2L) {
            this.validRows -= (long)n2;
        }
        this.beyondRowData = Math.max(this.beyondRowData, this.rowData.getPosition());
        this.calculateCheckSum();
    }

    @Override
    void continueReadRow(int n2) throws SQLException {
        try {
            if (!this.isFetchStreams) {
                T4C8Oall t4C8Oall = this.t4Connection.all8;
                t4C8Oall.continueReadRow(n2, this);
                this.beyondRowData = Math.max(this.beyondRowData, this.rowData.getPosition());
            }
        }
        catch (IOException iOException) {
            ((T4CConnection)this.connection).handleIOException(iOException);
            throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == DatabaseError.getVendorCode(110)) {
                this.sqlWarning = DatabaseError.addSqlWarning(this.sqlWarning, 110);
            }
            throw sQLException;
        }
    }

    @Override
    void doClose() throws SQLException {
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.do_close");
        if (this.cursorId != 0) {
            this.t4Connection.closeCursor(this.cursorId);
        }
        this.tmpByteArray = null;
        this.tmpBindsByteArray = null;
        this.definedColumnType = null;
        this.definedColumnSize = null;
        this.definedColumnFormOfUse = null;
        this.oacdefSent = null;
    }

    @Override
    void closeQuery() throws SQLException {
        this.connection.needLine();
        this.t4Connection.assertLoggedOn("oracle.jdbc.driver.T4CCallableStatement.closeQuery");
        if (this.streamList != null) {
            while (this.nextStream != null) {
                try {
                    this.nextStream.close();
                }
                catch (IOException iOException) {
                    ((T4CConnection)this.connection).handleIOException(iOException);
                    throw (SQLException)DatabaseError.createSqlException(iOException).fillInStackTrace();
                }
                this.nextStream = this.nextStream.nextStream;
            }
        }
        if (!this.isAllFetched && this.cursorId != 0) {
            this.t4Connection.closeQuery(this.cursorId);
        }
    }

    @Override
    Binder getRowidNullBinder(int n2) throws SQLException {
        if (this.sqlKind == OracleStatement.SqlKind.CALL_BLOCK) {
            this.currentRowCharLens[n2] = 1;
            return new VarcharNullBinder();
        }
        return this.createRowidNullBinder();
    }

    @Override
    Accessor allocateIndexTableAccessor(PlsqlIbtBindInfo plsqlIbtBindInfo, short s2) throws SQLException {
        return new T4CPlsqlIndexTableAccessor(this, plsqlIbtBindInfo, s2, this.t4Connection.mare);
    }

    @Override
    void endOfResultSet(boolean bl) throws SQLException {
        super.endOfResultSet(bl);
        this.rowData.free();
    }

    @Override
    public byte[] getRuntimeKey() throws SQLException {
        if (this.md == null) {
            try {
                this.md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return null;
            }
        } else {
            this.md.reset();
        }
        if (this.maxRows > 0L) {
            return null;
        }
        for (String string : this.nlsStrings) {
            String string2 = (String)this.connection.sessionProperties.get(string);
            if (string2 == null) continue;
            this.md.update(string2.getBytes(StandardCharsets.UTF_16));
        }
        if (this.t4Connection.currentSchema != null) {
            this.md.update(this.t4Connection.currentSchema.getBytes(StandardCharsets.UTF_16));
        }
        this.runtimeKey = this.md.digest();
        return this.runtimeKey;
    }

    @Override
    Object[] handleOtherPlsqlTypes(int n2, Object object, int n3, int[] nArray) throws SQLException {
        Datum[] datumArray = null;
        switch (n2) {
            case 12: {
                OracleTypeDATE oracleTypeDATE = new OracleTypeDATE();
                datumArray = oracleTypeDATE.toDatumArray(object, this.connection, 1L, n3);
                if (datumArray == null) break;
                nArray[0] = 8;
                break;
            }
            case 180: {
                OracleTypeTIMESTAMP oracleTypeTIMESTAMP = new OracleTypeTIMESTAMP(this.connection);
                datumArray = oracleTypeTIMESTAMP.toDatumArray(object, this.connection, 1L, n3);
                if (datumArray == null) break;
                nArray[0] = 8;
            }
        }
        return datumArray;
    }

    @Override
    protected final void prepareForExecuteWithDRCP() throws SQLException {
        if (this.cursorId != 0 && !this.t4Connection.canSendCursorIds()) {
            this.t4Connection.closeCursor(this.cursorId);
            this.clearCursorId();
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

