/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.common.runtime;

import com.cronutils.model.CronType;
import io.quarkus.scheduler.common.runtime.ScheduledInvoker;
import io.quarkus.scheduler.common.runtime.ScheduledMethodMetadata;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.ExecutorService;

public interface SchedulerContext {
    public ExecutorService getExecutor();

    public CronType getCronType();

    public List<ScheduledMethodMetadata> getScheduledMethods();

    default public ScheduledInvoker createInvoker(String invokerClassName) {
        try {
            Class<?> invokerClazz = Thread.currentThread().getContextClassLoader().loadClass(invokerClassName);
            return (ScheduledInvoker)invokerClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Unable to create invoker: " + invokerClassName, e);
        }
    }
}

