/*
 * Decompiled with CFR 0.152.
 */
package org.kie.processmigration.service.impl;

import io.quarkus.credentials.runtime.CredentialsProviderFinder;
import io.quarkus.runtime.Startup;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.processmigration.model.BpmNode;
import org.kie.processmigration.model.KieServerConfig;
import org.kie.processmigration.model.ProcessInfo;
import org.kie.processmigration.model.ProcessRef;
import org.kie.processmigration.model.RunningInstance;
import org.kie.processmigration.model.config.KieClientCert;
import org.kie.processmigration.model.config.KieServers;
import org.kie.processmigration.model.exceptions.CredentialsException;
import org.kie.processmigration.model.exceptions.InvalidKieServerException;
import org.kie.processmigration.model.exceptions.ProcessDefinitionNotFoundException;
import org.kie.processmigration.service.KieService;
import org.kie.server.api.exception.KieServicesHttpException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.definition.ProcessDefinition;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.ProcessServicesClient;
import org.kie.server.client.QueryServicesClient;
import org.kie.server.client.UIServicesClient;
import org.kie.server.client.admin.ProcessAdminServicesClient;
import org.kie.server.client.credentials.EnteredCredentialsProvider;
import org.kie.server.client.credentials.EnteredTokenCredentialsProvider;
import org.kie.server.common.rest.ClientCertificate;
import org.kie.server.common.rest.NoEndpointFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Startup
public class KieServiceImpl
implements KieService {
    private static final String CONFIGURATION_TIMEOUT = "60S";
    private static final Integer DEFAULT_PAGE_SIZE = 100;
    private static final long AWAIT_EXECUTOR = 5L;
    private static final long RETRY_DELAY = 2L;
    private static final Logger logger = LoggerFactory.getLogger(KieServiceImpl.class);
    private static final List<Integer> RUNNING_STATUSES = List.of(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(4));
    private static final String DEFAULT_SORT_COLUMN = "processInstanceId";
    private static final String DESC_SORT_ORDER = "desc";
    private io.quarkus.credentials.CredentialsProvider credentialsProvider = CredentialsProviderFinder.find((String)"quarkus.file.vault");
    final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    final Collection<KieServerConfig> configs = new ArrayList<KieServerConfig>();
    @ConfigProperty(name="quarkus.http.read-timeout", defaultValue="60S")
    Duration httpReadTimeout;
    @Inject
    KieServers kieServers;
    @Inject
    KieClientCert cert;

    @PostConstruct
    void loadConfigs() {
        if (this.kieServers.kieservers() != null && !this.kieServers.kieservers().isEmpty()) {
            this.kieServers.kieservers().forEach(this::loadConfig);
        }
    }

    @PreDestroy
    void shutdown() {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
        }
    }

    @Override
    public Collection<KieServerConfig> getConfigs() {
        return Collections.unmodifiableCollection(this.configs);
    }

    @Override
    public boolean hasKieServer(String kieServerId) {
        return this.configs.stream().anyMatch(config -> config.getId() != null && config.getId().equals(kieServerId));
    }

    @Override
    public KieServicesClient getClient(String kieServerId) throws InvalidKieServerException {
        return this.configs.stream().filter(config -> kieServerId.equals(config.getId())).findFirst().orElseThrow(() -> new InvalidKieServerException(kieServerId)).getClient();
    }

    @Override
    public ProcessAdminServicesClient getProcessAdminServicesClient(String kieServerId) throws InvalidKieServerException {
        return (ProcessAdminServicesClient)this.getClient(kieServerId).getServicesClient(ProcessAdminServicesClient.class);
    }

    @Override
    public QueryServicesClient getQueryServicesClient(String kieServerId) throws InvalidKieServerException {
        return (QueryServicesClient)this.getClient(kieServerId).getServicesClient(QueryServicesClient.class);
    }

    @Override
    public List<RunningInstance> getRunningInstances(String kieServerId, String containerId, Integer page, Integer pageSize, String sortBy, String orderBy) throws InvalidKieServerException {
        QueryServicesClient queryServicesClient = this.getQueryServicesClient(kieServerId);
        List instanceList = queryServicesClient.findProcessInstancesByContainerId(containerId, RUNNING_STATUSES, page, pageSize, this.translateSortColumn(sortBy), this.getOrderBy(orderBy).booleanValue());
        int i = 0;
        ArrayList<RunningInstance> result = new ArrayList<RunningInstance>();
        for (ProcessInstance instance : instanceList) {
            result.add(new RunningInstance(++i, instance));
        }
        return result;
    }

    private String translateSortColumn(String column) {
        if (column == null) {
            return DEFAULT_SORT_COLUMN;
        }
        switch (column) {
            case "name": {
                return "processName";
            }
            case "description": {
                return "processInstanceDescription";
            }
            case "startTime": {
                return "start_date";
            }
            case "state": {
                return "log.status";
            }
        }
        return DEFAULT_SORT_COLUMN;
    }

    private Boolean getOrderBy(String orderBy) {
        return !DESC_SORT_ORDER.equalsIgnoreCase(orderBy);
    }

    @Override
    public Long countRunningInstances(String kieServerId, String containerId) throws InvalidKieServerException {
        return this.getQueryServicesClient(kieServerId).countProcessInstancesByContainerId(containerId, RUNNING_STATUSES);
    }

    @Override
    public Map<String, Set<String>> getDefinitions(String kieServerId) throws InvalidKieServerException {
        HashMap<String, Set<String>> definitions = new HashMap<String, Set<String>>();
        ServiceResponse response = this.getClient(kieServerId).listContainers();
        QueryServicesClient queryServicesClient = this.getQueryServicesClient(kieServerId);
        ((KieContainerResourceList)response.getResult()).getContainers().forEach(container -> {
            if (!definitions.containsKey(container.getContainerId())) {
                definitions.put(container.getContainerId(), new HashSet());
            }
            boolean finished = false;
            int page = 0;
            while (!finished) {
                List processes = queryServicesClient.findProcessesByContainerId(container.getContainerId(), Integer.valueOf(page++), DEFAULT_PAGE_SIZE);
                if (processes.size() < DEFAULT_PAGE_SIZE) {
                    finished = true;
                }
                processes.forEach(definition -> ((Set)definitions.get(container.getContainerId())).add(definition.getId()));
            }
        });
        return definitions;
    }

    @Override
    public boolean existsProcessDefinition(String kieServerId, ProcessRef processRef) throws InvalidKieServerException {
        QueryServicesClient queryService = this.getQueryServicesClient(kieServerId);
        return queryService.findProcessByContainerIdProcessId(processRef.getContainerId(), processRef.getProcessId()) != null;
    }

    @Override
    public ProcessInfo getDefinition(String kieServerId, ProcessRef processRef) throws ProcessDefinitionNotFoundException, InvalidKieServerException {
        String svgFile;
        ProcessInfo processInfo = new ProcessInfo();
        try {
            svgFile = this.getUIServicesClient(kieServerId).getProcessImage(processRef.getContainerId(), processRef.getProcessId());
        }
        catch (KieServicesHttpException e) {
            if (Response.Status.NOT_FOUND.getStatusCode() == e.getHttpCode().intValue()) {
                logger.debug("Process definition {} not found in {}", (Object)processRef, (Object)kieServerId);
                throw new ProcessDefinitionNotFoundException(kieServerId, processRef);
            }
            logger.warn("Unable to fetch SVG file from {}", (Object)kieServerId, (Object)e);
            throw e;
        }
        svgFile = svgFile.replaceAll("\\?shapeType=BACKGROUND", "_shapeType_BACKGROUND");
        processInfo.setSvgFile(svgFile);
        ProcessDefinition pd = this.getProcessServicesClient(kieServerId).getProcessDefinition(processRef.getContainerId(), processRef.getProcessId());
        if (!pd.getContainerId().equals(processRef.getContainerId())) {
            throw new ProcessDefinitionNotFoundException(kieServerId, processRef);
        }
        List<BpmNode> nodes = new ArrayList<BpmNode>();
        if (pd.getNodes() != null) {
            nodes = pd.getNodes().stream().map(n -> new BpmNode().setId(n.getUniqueId()).setName(n.getName()).setType(n.getType())).collect(Collectors.toCollection(ArrayList::new));
        }
        processInfo.setNodes(nodes);
        processInfo.setContainerId(processRef.getContainerId());
        processInfo.setProcessId(processRef.getProcessId());
        return processInfo;
    }

    private void loadConfig(KieServers.KieServer config) {
        KieServerConfig kieConfig = new KieServerConfig().setHost(config.host());
        if (config.credentialsProvider().isPresent()) {
            String user = (String)this.credentialsProvider.getCredentials(config.credentialsProvider().get()).get("user");
            String password = (String)this.credentialsProvider.getCredentials(config.credentialsProvider().get()).get("password");
            if (user == null) {
                throw new CredentialsException("Missing credential in vault with key " + config.credentialsProvider().get());
            }
            kieConfig.setCredentialsProvider((CredentialsProvider)new EnteredCredentialsProvider(user, password));
        } else if (config.username().isPresent() && config.password().isPresent()) {
            kieConfig.setCredentialsProvider((CredentialsProvider)new EnteredCredentialsProvider(config.username().get(), config.password().get()));
        }
        if (config.token().isPresent()) {
            kieConfig.setCredentialsProvider((CredentialsProvider)new EnteredTokenCredentialsProvider(config.token().get()));
        }
        try {
            KieServicesClient client = this.createKieServicesClient(kieConfig);
            kieConfig.setClient(client);
            if (client.getServerInfo().getResult() != null) {
                kieConfig.setName(((KieServerInfo)client.getServerInfo().getResult()).getName()).setId(((KieServerInfo)client.getServerInfo().getResult()).getServerId());
            }
        }
        catch (Exception e) {
            logger.info("Unable to create kie server configuration for {}. Retry asynchronously", (Object)config);
            this.retryConnection(kieConfig);
        }
        this.configs.add(kieConfig);
        logger.info("Loaded kie server configuration for: {}", (Object)kieConfig);
    }

    private KieServicesClient createKieServicesClient(KieServerConfig config) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)config.getHost(), (CredentialsProvider)config.getCredentialsProvider());
        configuration.setTimeout(this.httpReadTimeout.toMillis());
        configuration.setMarshallingFormat(MarshallingFormat.JSON);
        if (this.cert.clientCert().isPresent()) {
            configuration.setClientCertificate(new ClientCertificate().setCertName(this.cert.clientCert().get().certName()).setCertPassword(this.resolvePassword(this.cert.clientCert().get().certCredentialsProvider(), this.cert.clientCert().get().certPassword())).setKeystore(this.cert.clientCert().get().keystorePath()).setKeystorePassword(this.resolvePassword(this.cert.clientCert().get().keystoreCredentialsProvider(), this.cert.clientCert().get().keystorePassword())).setTruststore(this.cert.clientCert().get().truststorePath()).setTruststorePassword(this.resolvePassword(this.cert.clientCert().get().truststoreCredentialsProvider(), this.cert.clientCert().get().truststorePassword())));
        }
        return KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
    }

    private String resolvePassword(Optional<String> credentialsProviderKey, Optional<String> passwordKey) {
        if (credentialsProviderKey.isPresent()) {
            String password = (String)this.credentialsProvider.getCredentials(credentialsProviderKey.get()).get("password");
            if (password == null) {
                throw new CredentialsException("Missing credential in vault with key " + credentialsProviderKey.get());
            }
            return password;
        }
        if (passwordKey.isEmpty()) {
            throw new CredentialsException("Either the password or the credentials-provider key must be defined");
        }
        return passwordKey.get();
    }

    private UIServicesClient getUIServicesClient(String kieServerId) throws InvalidKieServerException {
        return (UIServicesClient)this.getClient(kieServerId).getServicesClient(UIServicesClient.class);
    }

    private ProcessServicesClient getProcessServicesClient(String kieServerId) throws InvalidKieServerException {
        return (ProcessServicesClient)this.getClient(kieServerId).getServicesClient(ProcessServicesClient.class);
    }

    private void retryConnection(KieServerConfig kieConfig) {
        this.executorService.schedule(new KieServerClientConnector(kieConfig), 2L, TimeUnit.SECONDS);
    }

    class KieServerClientConnector
    implements Runnable {
        final KieServerConfig kieConfig;

        KieServerClientConnector(KieServerConfig kieConfig) {
            this.kieConfig = kieConfig;
        }

        @Override
        public void run() {
            logger.debug("Trying to create KieServerClient for {}", (Object)this.kieConfig);
            if (this.kieConfig.getClient() == null) {
                try {
                    this.kieConfig.setClient(KieServiceImpl.this.createKieServicesClient(this.kieConfig));
                }
                catch (NoEndpointFoundException e) {
                    logger.warn("Unable to connect to KieServer: {}. The client will try to reconnect in the background", (Object)this.kieConfig);
                }
                catch (Exception e) {
                    logger.warn("Unable to create KieServer client: {}", (Object)this.kieConfig, (Object)e);
                }
                finally {
                    if (this.kieConfig.getClient() == null) {
                        logger.debug("KieServerClient for {} could not be created. Retrying...", (Object)this.kieConfig);
                        KieServiceImpl.this.retryConnection(this.kieConfig);
                    } else {
                        logger.debug("KieServerClient for {} created.", (Object)this.kieConfig);
                    }
                }
            }
        }
    }
}

