/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.BundleData;
import org.eclipse.transformer.action.impl.BundleDataImpl;
import org.eclipse.transformer.util.SignatureUtils;

public class TransformProperties {
    public static final char PACKAGE_RENAME_ASSIGNMENT = '=';
    public static final String RESOURCE_EXCLUSION = "!";

    public static void addSelections(Map<String, String> included, Map<String, String> excluded, Map<String, String> selections) {
        for (Map.Entry<String, String> selectionEntry : selections.entrySet()) {
            String selection = selectionEntry.getKey();
            String charset = selectionEntry.getValue();
            TransformProperties.addSelection(included, excluded, selection, charset);
        }
    }

    public static void addSelection(Map<String, String> included, Map<String, String> excluded, String selection, String charset) {
        selection = selection.trim();
        if ((charset = charset.trim()).startsWith(RESOURCE_EXCLUSION)) {
            excluded.put(selection, charset.substring(1));
        } else {
            included.put(selection, charset);
        }
    }

    public static Map<String, String> invert(Map<String, String> properties) {
        HashMap<String, String> inverseProperties = new HashMap<String, String>(properties.size());
        properties.forEach((key, value) -> {
            if (SignatureUtils.containsWildcard(key)) {
                value = value.concat(key.substring(key.length() - 2));
                key = SignatureUtils.stripWildcard(key);
            }
            inverseProperties.put((String)value, (String)key);
        });
        return inverseProperties;
    }

    public static void setPackageVersions(Map<?, ?> versionProperties, Map<String, String> packageVersions, Map<String, Map<String, String>> specificPackageVersions) {
        for (Map.Entry<?, ?> versionEntry : versionProperties.entrySet()) {
            TransformProperties.setPackageVersions((String)versionEntry.getKey(), (String)versionEntry.getValue(), packageVersions, specificPackageVersions);
        }
    }

    public static void setPackageVersions(String newPackageName, String newVersion, Map<String, String> packageVersions, Map<String, Map<String, String>> specificPackageVersions) {
        if (newVersion.indexOf(61) == -1 && newVersion.indexOf(59) == -1) {
            newVersion = newVersion.replace("\\", "");
            TransformProperties.setVersion(newPackageName, newVersion, packageVersions);
            return;
        }
        int length = newVersion.length();
        boolean escaped = false;
        StringBuilder nameBuilder = new StringBuilder();
        StringBuilder versionBuilder = new StringBuilder();
        for (int offset = 0; offset < length; ++offset) {
            char nextChar = newVersion.charAt(offset);
            if (escaped) {
                escaped = false;
                versionBuilder.append(nextChar);
                continue;
            }
            if (nextChar == '\\') {
                escaped = true;
                continue;
            }
            if (nextChar == '=') {
                if (versionBuilder == nameBuilder) {
                    throw new IllegalArgumentException("Package version syntax error: Too many '=' in [ " + newVersion + " ]");
                }
                StringBuilder currentBuilder = nameBuilder;
                nameBuilder = versionBuilder;
                versionBuilder = currentBuilder;
                continue;
            }
            if (nextChar == ';') {
                if (versionBuilder.length() != 0) {
                    TransformProperties.setVersion(newPackageName, newVersion, nameBuilder, versionBuilder, packageVersions, specificPackageVersions);
                    continue;
                }
                if (nameBuilder.length() == 0) continue;
                throw new IllegalArgumentException("Package version syntax error: Version missing for package [ " + newPackageName + " ] and attribute [ " + nameBuilder.toString() + " ]");
            }
            versionBuilder.append(nextChar);
        }
        if (versionBuilder.length() != 0) {
            TransformProperties.setVersion(newPackageName, newVersion, nameBuilder, versionBuilder, packageVersions, specificPackageVersions);
        }
    }

    public static String setVersion(String newPackageName, String newVersion, Map<String, String> packageVersions) {
        return packageVersions.put(newPackageName, newVersion);
    }

    public static void setVersion(String newPackageName, String newVersion, StringBuilder nameBuilder, StringBuilder versionBuilder, Map<String, String> packageVersions, Map<String, Map<String, String>> specificPackageVersions) {
        String propertyName;
        if (versionBuilder.length() == 0) {
            throw new IllegalArgumentException("Package version syntax error: No version in [ " + newVersion + " ]");
        }
        String versionText = versionBuilder.toString();
        versionBuilder.setLength(0);
        if (nameBuilder.length() == 0) {
            propertyName = null;
        } else {
            propertyName = nameBuilder.toString();
            nameBuilder.setLength(0);
        }
        if (propertyName == null) {
            packageVersions.put(newPackageName, versionText);
        } else {
            Map<String, String> versionsForProperty = specificPackageVersions.get(propertyName);
            if (versionsForProperty == null) {
                versionsForProperty = new HashMap<String, String>();
                specificPackageVersions.put(propertyName, versionsForProperty);
            }
            versionsForProperty.put(newPackageName, versionText);
        }
    }

    public static Map<String, BundleData> getBundleUpdates(Map<?, ?> updateProperties) {
        HashMap<String, BundleData> bundleUpdates = new HashMap<String, BundleData>(updateProperties.size());
        for (Map.Entry<?, ?> updateEntry : updateProperties.entrySet()) {
            bundleUpdates.put((String)updateEntry.getKey(), new BundleDataImpl((String)updateEntry.getValue()));
        }
        return bundleUpdates;
    }

    public static Map<String, String> convertPropertiesToMap(Properties properties) {
        return TransformProperties.copyPropertiesToMap(properties, new HashMap(properties.size()));
    }

    public static <MAP extends Map<String, String>> MAP copyPropertiesToMap(Properties properties, MAP map) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put((String)((String)entry.getKey()), (String)((String)entry.getValue()));
        }
        return map;
    }

    public static boolean isFeatureManifest(String manifestPath, File manifestFile) throws TransformException {
        FileReader manifestReader;
        try {
            manifestReader = new FileReader(manifestFile);
        }
        catch (IOException e) {
            throw new TransformException("Failed to open [ " + manifestPath + " ]", e);
        }
        try {
            String line;
            BufferedReader bufferedReader = new BufferedReader(manifestReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (line.length() <= 72) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new TransformException("Failed to read  [ " + manifestPath + " ]", e);
        }
        finally {
            try {
                manifestReader.close();
            }
            catch (IOException e) {
                throw new TransformException("Failed to close  [ " + manifestPath + " ]", e);
            }
        }
    }
}

