/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import org.eclipse.transformer.Transformer;
import org.eclipse.transformer.action.impl.ElementChangesImpl;
import org.slf4j.Logger;

public class ClassChangesImpl
extends ElementChangesImpl {
    private String inputClassName;
    private String outputClassName;
    private String inputSuperName;
    private String outputSuperName;
    private int modifiedInterfaces;
    private int modifiedFields;
    private int modifiedMethods;
    private int modifiedAttributes;
    private int modifiedConstants;

    @Override
    public boolean isContentChanged() {
        String inputClassName = this.getInputClassName();
        String outputClassName = this.getOutputClassName();
        String inputSuperName = this.getInputSuperName();
        String outputSuperName = this.getOutputSuperName();
        return super.isContentChanged() || inputClassName != null && outputClassName != null && !inputClassName.equals(outputClassName) || inputSuperName != null && outputSuperName != null && !inputSuperName.equals(outputSuperName);
    }

    public String getInputClassName() {
        return this.inputClassName;
    }

    public void setInputClassName(String inputClassName) {
        this.inputClassName = inputClassName;
    }

    public String getOutputClassName() {
        return this.outputClassName;
    }

    public void setOutputClassName(String outputClassName) {
        this.outputClassName = outputClassName;
    }

    public String getInputSuperName() {
        return this.inputSuperName;
    }

    public void setInputSuperName(String inputSuperName) {
        this.inputSuperName = inputSuperName;
    }

    public String getOutputSuperName() {
        return this.outputSuperName;
    }

    public void setOutputSuperName(String outputSuperName) {
        this.outputSuperName = outputSuperName;
    }

    public int getModifiedInterfaces() {
        return this.modifiedInterfaces;
    }

    public void addModifiedInterface() {
        ++this.modifiedInterfaces;
        this.addReplacement();
    }

    public int getModifiedFields() {
        return this.modifiedFields;
    }

    public void addModifiedField() {
        ++this.modifiedFields;
        this.addReplacement();
    }

    public int getModifiedMethods() {
        return this.modifiedMethods;
    }

    public void addModifiedMethod() {
        ++this.modifiedMethods;
        this.addReplacement();
    }

    public int getModifiedAttributes() {
        return this.modifiedAttributes;
    }

    public void addModifiedAttribute() {
        ++this.modifiedAttributes;
        this.addReplacement();
    }

    public int getModifiedConstants() {
        return this.modifiedConstants;
    }

    public void addModifiedConstant() {
        ++this.modifiedConstants;
        this.addReplacement();
    }

    public void addModifiedConstants(int additions) {
        this.modifiedConstants += additions;
        this.addReplacements(additions);
    }

    @Override
    public void logChanges(Logger logger) {
        super.logChanges(logger);
        logger.info(Transformer.consoleMarker, "Class name [ {} ] [ {} ]", (Object)this.getInputClassName(), (Object)this.getOutputClassName());
        String inputSuperName = this.getInputSuperName();
        if (inputSuperName != null) {
            logger.debug(Transformer.consoleMarker, "Super class name [ {} ] [ {} ]", (Object)inputSuperName, (Object)this.getOutputSuperName());
        }
        logger.debug(Transformer.consoleMarker, "Modified interfaces [ {} ]", (Object)this.getModifiedInterfaces());
        logger.debug(Transformer.consoleMarker, "Modified fields     [ {} ]", (Object)this.getModifiedFields());
        logger.debug(Transformer.consoleMarker, "Modified methods    [ {} ]", (Object)this.getModifiedMethods());
        logger.debug(Transformer.consoleMarker, "Modified constants  [ {} ]", (Object)this.getModifiedConstants());
    }
}

