/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import java.io.File;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionContext;
import org.eclipse.transformer.action.ByteData;
import org.eclipse.transformer.action.ElementAction;
import org.eclipse.transformer.action.impl.ActionImpl;
import org.eclipse.transformer.action.impl.ElementChangesImpl;

public abstract class ElementActionImpl
extends ActionImpl
implements ElementAction {
    public ElementActionImpl(ActionContext context) {
        super(context);
    }

    @Override
    public boolean isElementAction() {
        return true;
    }

    @Override
    public ElementChangesImpl newChanges() {
        return new ElementChangesImpl();
    }

    @Override
    public ElementChangesImpl getActiveChanges() {
        return (ElementChangesImpl)super.getActiveChanges();
    }

    @Override
    public ElementChangesImpl getLastActiveChanges() {
        return (ElementChangesImpl)super.getLastActiveChanges();
    }

    public void addReplacement() {
        this.getActiveChanges().addReplacement();
    }

    public void addReplacements(int additions) {
        this.getActiveChanges().addReplacements(additions);
    }

    @Override
    public boolean acceptResource(String resourceName, File resourceFile) {
        return this.matchResourceName(resourceName);
    }

    @Override
    public void apply(String inputName, File inputFile, String outputName, File outputFile) throws TransformException {
        TransformException transformError;
        ByteData outputData;
        ByteData inputData = this.collect(inputName, inputFile);
        try {
            outputData = this.apply(inputData);
            transformError = null;
        }
        catch (TransformException t) {
            outputData = inputData;
            transformError = t;
        }
        this.write(outputData, outputFile);
        if (transformError != null) {
            throw transformError;
        }
    }

    protected void apply(String inputName, File inputFile, File outputRoot) throws TransformException {
        TransformException transformError;
        ByteData outputData;
        ByteData inputData = this.collect(inputName, inputFile);
        try {
            outputData = this.apply(inputData);
            transformError = null;
        }
        catch (TransformException t) {
            outputData = inputData;
            transformError = t;
        }
        File outputFile = new File(outputRoot, outputData.name());
        this.write(outputData, outputFile);
        if (transformError != null) {
            throw transformError;
        }
    }

    @Override
    public abstract ByteData apply(ByteData var1) throws TransformException;
}

