/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.action.impl;

import aQute.lib.io.ByteBufferOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ActionContext;
import org.eclipse.transformer.action.ActionType;
import org.eclipse.transformer.action.ByteData;
import org.eclipse.transformer.action.impl.ByteDataImpl;
import org.eclipse.transformer.action.impl.ElementActionImpl;
import org.eclipse.transformer.action.impl.ServiceLoaderConfigChangesImpl;
import org.eclipse.transformer.util.FileUtils;
import org.eclipse.transformer.util.LineSeparatorBufferedReader;

public class ServiceLoaderConfigActionImpl
extends ElementActionImpl {
    public static final String META_INF_SERVICES = "META-INF/services/";

    public ServiceLoaderConfigActionImpl(ActionContext context) {
        super(context);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.SERVICE_LOADER_CONFIG;
    }

    @Override
    public ServiceLoaderConfigChangesImpl newChanges() {
        return new ServiceLoaderConfigChangesImpl();
    }

    @Override
    public ServiceLoaderConfigChangesImpl getActiveChanges() {
        return (ServiceLoaderConfigChangesImpl)super.getActiveChanges();
    }

    @Override
    public ServiceLoaderConfigChangesImpl getLastActiveChanges() {
        return (ServiceLoaderConfigChangesImpl)super.getLastActiveChanges();
    }

    protected void addUnchangedProvider() {
        this.getActiveChanges().addUnchangedProvider();
    }

    protected void addChangedProvider() {
        this.getActiveChanges().addChangedProvider();
    }

    @Override
    public boolean acceptResource(String resourceName, File resourceFile) {
        return resourceName.contains(META_INF_SERVICES) && !resourceName.endsWith(META_INF_SERVICES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteData apply(ByteData inputData) throws TransformException {
        this.startRecording(inputData);
        try {
            ByteData byteData;
            String inputName = inputData.name();
            String outputName = this.packageRenameInput(inputName);
            if (outputName == null) {
                outputName = inputName;
            } else {
                this.getLogger().debug("Service name  [ {} ] -> [ {} ]", (Object)inputName, (Object)outputName);
            }
            this.setResourceNames(inputName, outputName);
            ByteBufferOutputStream outputStream = new ByteBufferOutputStream(inputData.length());
            Charset charset = inputData.charset();
            try (LineSeparatorBufferedReader reader = new LineSeparatorBufferedReader(inputData.reader());
                 BufferedWriter writer = FileUtils.writer((OutputStream)outputStream, charset);){
                this.transform(reader, writer);
            }
            catch (IOException e) {
                throw new TransformException("Failed to transform [ " + inputName + " ]", e);
            }
            if (!this.isChanged()) {
                byteData = inputData;
                return byteData;
            }
            if (!this.isContentChanged()) {
                byteData = inputData.copy(outputName);
                return byteData;
            }
            byteData = new ByteDataImpl(outputName, outputStream.toByteBuffer(), charset);
            return byteData;
        }
        finally {
            this.stopRecording(inputData);
        }
    }

    protected void transform(LineSeparatorBufferedReader reader, BufferedWriter writer) throws IOException {
        String inputLine;
        while ((inputLine = reader.readLine()) != null) {
            String outputLine;
            String outputPackageName;
            int dotLocation;
            int poundLocation = inputLine.indexOf(35);
            String inputPackageName = poundLocation != -1 ? inputLine.substring(0, poundLocation) : inputLine;
            if ((inputPackageName = inputPackageName.trim()).isEmpty()) {
                dotLocation = -1;
                outputPackageName = null;
            } else {
                dotLocation = inputPackageName.lastIndexOf(46);
                if (dotLocation == -1) {
                    outputPackageName = null;
                } else if (dotLocation == 0) {
                    outputPackageName = null;
                } else {
                    inputPackageName = inputPackageName.substring(0, dotLocation);
                    outputPackageName = this.replacePackage(inputPackageName);
                }
            }
            if (outputPackageName == null) {
                outputLine = inputLine;
                this.addUnchangedProvider();
            } else {
                int inputPackageStart = inputLine.indexOf(inputPackageName);
                int inputPackageEnd = inputPackageStart + dotLocation;
                outputLine = inputLine.substring(0, inputPackageStart) + outputPackageName + inputLine.substring(inputPackageEnd);
                this.addChangedProvider();
            }
            writer.write(outputLine);
            writer.write(reader.lineSeparator());
        }
    }
}

