/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.util;

import aQute.lib.io.ByteBufferInputStream;
import aQute.lib.io.IO;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.eclipse.transformer.TransformException;
import org.eclipse.transformer.action.ByteData;
import org.eclipse.transformer.action.impl.ByteDataImpl;
import org.slf4j.Logger;

public class FileUtils {
    public static final int PAGE_SIZE = 4096;
    public static final int BUFFER_ADJUSTMENT = 65536;
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final char SLASH = '/';
    private static final Pattern PATH_SPLITTER = Pattern.compile("[/\\\\]");

    private FileUtils() {
    }

    public static void verifyArraySize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Array fill amount [ " + size + " ] less than zero [ 0 ]");
        }
        if (size > 0x7FFFFFF7) {
            throw new IllegalArgumentException("Array fill amount [ " + size + " ] greater than [ " + 0x7FFFFFF7 + " ]");
        }
    }

    public static void verifyArrayOffset(int offset, int size) {
        if (offset < 0) {
            throw new IllegalArgumentException("Array offset [ " + offset + " ] less than zero.");
        }
        if (offset > 0x7FFFFFF7) {
            throw new IllegalArgumentException("Array offset [ " + offset + " ] greater than [ " + 0x7FFFFFF7 + " ]");
        }
        if (offset > size) {
            throw new IllegalArgumentException("Array offset [ " + offset + " ] greater than array size [ " + size + " ]");
        }
    }

    public static void verifyArray(int offset, int size) {
        FileUtils.verifyArraySize(size);
        FileUtils.verifyArrayOffset(offset, size);
    }

    public static ByteData read(Logger logger, String inputName, Charset charset, InputStream inputStream, int requested) throws IOException {
        logger.debug("Reading [ {} ] bytes [ {} ]", (Object)inputName, (Object)requested);
        ByteBuffer initialBuffer = ByteBuffer.allocate(requested < 0 ? 65536 : requested);
        ByteBuffer finalBuffer = FileUtils.read(inputName, inputStream, initialBuffer, requested);
        if (requested < 0) {
            logger.debug("Read [ {} ] bytes [ {} ]", (Object)inputName, (Object)finalBuffer.limit());
        }
        return new ByteDataImpl(inputName, finalBuffer, charset);
    }

    public static ByteBuffer read(String inputName, InputStream inputStream, ByteBuffer outputBuffer, int requested) throws IOException {
        if (requested == 0) {
            outputBuffer.position(0);
            outputBuffer.limit(0);
            return outputBuffer;
        }
        int outputCapacity = outputBuffer.capacity();
        int read = 0;
        if (requested > 0) {
            int unread;
            int bytesRead;
            FileUtils.verifyArraySize(requested);
            if (requested > outputCapacity) {
                outputBuffer = ByteBuffer.allocate(requested);
                outputCapacity = requested;
            }
            byte[] buf = outputBuffer.array();
            for (unread = requested; unread > 0 && (bytesRead = inputStream.read(buf, read, unread)) != -1; unread -= bytesRead) {
                read += bytesRead;
            }
            if (unread > 0) {
                throw new IOException("Underflow of [ " + inputName + " ].  Read [ " + read + " ] bytes, expected [ " + requested + " ].");
            }
        } else {
            int bytesRead;
            byte[] buf = outputBuffer.array();
            int unused = outputCapacity;
            while ((bytesRead = inputStream.read(buf, read, unused)) != -1) {
                read += bytesRead;
                unused -= bytesRead;
                if (inputStream.available() == 0) break;
                if (unused != 0) continue;
                if (read == 0x7FFFFFF7) {
                    throw new IOException("Overflow of [ " + inputName + " ].  Read [ " + read + " ] bytes (MAX_ARRAY_LENGTH).");
                }
                int maxAdjustment = 0x7FFFFFF7 - read;
                int adjustment = 65536 > maxAdjustment ? maxAdjustment : 65536;
                outputBuffer = ByteBuffer.allocate(outputCapacity += adjustment);
                unused = adjustment;
                byte[] oldBuf = buf;
                buf = outputBuffer.array();
                System.arraycopy(oldBuf, 0, buf, 0, read);
            }
        }
        outputBuffer.position(0);
        outputBuffer.limit(read);
        return outputBuffer;
    }

    public static ByteBuffer read(String inputName, InputStream inputStream, ByteBuffer buffer) throws IOException {
        return FileUtils.read(inputName, inputStream, buffer, -1);
    }

    public static ByteBuffer read(String inputName, InputStream inputStream) throws IOException {
        return FileUtils.read(inputName, inputStream, ByteBuffer.allocate(65536));
    }

    public static long transfer(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buffer = new byte[65536];
        return FileUtils.transfer(inputStream, outputStream, buffer);
    }

    public static long transfer(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        long totalBytesRead = 0L;
        int bytesRead = 0;
        while ((bytesRead = inputStream.read(buffer, 0, buffer.length)) != -1) {
            totalBytesRead += (long)bytesRead;
            outputStream.write(buffer, 0, bytesRead);
        }
        return totalBytesRead;
    }

    public static String getFileNameFromFullyQualifiedFileName(String fqFileName) {
        int index = fqFileName.lastIndexOf(47);
        if (index != -1) {
            return fqFileName.substring(index + 1);
        }
        return fqFileName;
    }

    public static InputStream stream(ByteBuffer buffer) {
        InputStream stream = IO.stream((ByteBuffer)buffer);
        return stream;
    }

    public static Reader reader(ByteBuffer buffer, Charset charset) {
        InputStreamReader reader = new InputStreamReader((InputStream)new ByteBufferInputStream(buffer), charset);
        return reader;
    }

    public static BufferedWriter writer(OutputStream outputStream, Charset charset) {
        OutputStreamWriter outputWriter = new OutputStreamWriter(outputStream, charset);
        BufferedWriter writer = new BufferedWriter(outputWriter);
        return writer;
    }

    public static String sanitize(String entryName) {
        String normalized;
        if (entryName.isEmpty()) {
            return entryName;
        }
        try {
            normalized = Paths.get("", PATH_SPLITTER.split(entryName)).normalize().toString().replace('\\', '/');
        }
        catch (InvalidPathException e) {
            throw new TransformException("Zip entry name is not a valid path [ " + entryName + " ]", e);
        }
        if (normalized.startsWith("..") && (normalized.length() == 2 || normalized.charAt(2) == '/')) {
            throw new TransformException("[ZIPSLIP]: Zip entry name has leading \"..\" [ " + entryName + " ]");
        }
        char lastChar = entryName.charAt(entryName.length() - 1);
        if (lastChar == '/' || lastChar == '\\') {
            normalized = normalized.concat("/");
        }
        return normalized;
    }
}

