/*
 * Decompiled with CFR 0.152.
 */
package org.rnorth.ducttape.circuitbreakers;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.rnorth.ducttape.circuitbreakers.State;
import org.rnorth.ducttape.circuitbreakers.StateStore;

class MapBackedStateStore
implements StateStore {
    private final Map<String, Object> map;
    private final String keyPrefix;

    public MapBackedStateStore(@NotNull Map<String, Object> map, @NotNull String keyPrefix) {
        this.map = map;
        this.keyPrefix = keyPrefix;
    }

    @Override
    public State getState() {
        return (State)((Object)this.map.getOrDefault(this.keyPrefix + "_STATE", (Object)State.OK));
    }

    @Override
    public void setState(@NotNull State state) {
        this.map.put(this.keyPrefix + "_STATE", (Object)state);
    }

    @Override
    public long getLastFailure() {
        return (Long)this.map.getOrDefault(this.keyPrefix + "_LAST_FAILURE", 0L);
    }

    @Override
    public void setLastFailure(long lastFailure) {
        this.map.put(this.keyPrefix + "_LAST_FAILURE", lastFailure);
    }
}

